/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;

public class Stone {
    public static final Stone NULL_STONE = new Stone();
    public static final Stone[] EMPTY_ARRAY = new Stone[0];
    private final SgfColor color_;
    private final SgfPoint point_;
    private final Integer number_;
    private final Double timeLapsed_;

    public static Stone create(Node node, SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)node, (Object)sgfSize);
        for (SgfColor sgfColor : new SgfColor[]{SgfColor.WHITE, SgfColor.BLACK}) {
            SgfPoint sgfPoint;
            Property property = node.getProperty(sgfColor.moveType());
            if (property == null || (sgfPoint = SgfPoint.parseMoveQuietly(sgfSize, property.getString())) == null) continue;
            return new Stone(sgfColor, sgfPoint, null);
        }
        return NULL_STONE;
    }

    private Stone() {
        this.color_ = null;
        this.point_ = null;
        this.number_ = null;
        this.timeLapsed_ = null;
    }

    public Stone(SgfColor sgfColor, SgfPoint sgfPoint, Integer n) {
        this(sgfColor, sgfPoint, n, null);
    }

    public Stone(SgfColor sgfColor, SgfPoint sgfPoint, Integer n, Double d) {
        ArgumentChecker.throwIfNull((Object)sgfColor, (Object)sgfPoint);
        this.color_ = sgfColor;
        this.point_ = sgfPoint;
        this.number_ = n;
        this.timeLapsed_ = d;
    }

    public SgfPoint getPoint() {
        return this.point_;
    }

    public SgfColor getColor() {
        return this.color_;
    }

    public Integer getNumber() {
        return this.number_;
    }

    public Double getTimeLapsed() {
        return this.timeLapsed_;
    }

    public boolean isValid() {
        return this.point_ != null && this.color_ != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Stone stone = (Stone)object;
        return Objects.equalsIncludeNull(this.color_, stone.color_) && Objects.equalsIncludeNull(this.point_, stone.point_) && Objects.equalsIncludeNull(this.number_, stone.number_);
    }

    public int hashCode() {
        return Objects.hashCodeIncludeNull(this.color_) + 3 * Objects.hashCodeIncludeNull(this.number_) + 1033 * Objects.hashCodeIncludeNull(this.point_);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

