/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import org.unitarou.sgf.type.SgfColor;

public class Situation {
    private final int whiteTerritory_;
    private final int whiteCaptured_;
    private final int blackTerritory_;
    private final int blackCaptured_;
    private final double komi_;

    public Situation(int n, int n2, int n3, int n4, double d) {
        this.whiteTerritory_ = n;
        this.whiteCaptured_ = n2;
        this.blackTerritory_ = n3;
        this.blackCaptured_ = n4;
        this.komi_ = d;
    }

    public double score() {
        return Math.abs((double)(this.blackTerritory_ + this.blackCaptured_ - (this.whiteTerritory_ + this.whiteCaptured_)) - this.komi_);
    }

    public SgfColor winner() {
        double d = (double)(this.blackTerritory_ + this.blackCaptured_ - (this.whiteTerritory_ + this.whiteCaptured_)) - this.komi_;
        if (d < 0.0) {
            return SgfColor.WHITE;
        }
        if (0.0 < d) {
            return SgfColor.BLACK;
        }
        return null;
    }

    public boolean hasNoTerritory() {
        return this.blackTerritory_ == 0 && this.whiteTerritory_ == 0;
    }

    public int getBlackCaptured() {
        return this.blackCaptured_;
    }

    public int getBlackTerritory() {
        return this.blackTerritory_;
    }

    public double getKomi() {
        return this.komi_;
    }

    public int getWhiteCaptured() {
        return this.whiteCaptured_;
    }

    public int getWhiteTerritory() {
        return this.whiteTerritory_;
    }
}

