/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFinder {
    public static boolean contains(Property property, String string) {
        ArgumentChecker.throwIfNull((Object)property, (Object)string);
        String[] stringArray = property.getStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Node findNode(Sequence sequence, PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)propertyType);
        for (Node node : sequence) {
            if (!node.contains(propertyType)) continue;
            return node;
        }
        return null;
    }

    public static Node findNode(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            return node;
        }
        return null;
    }

    public static Property findProperty(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public static String[] findData(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            String[] stringArray = BasicFinder.findDataImpl(node, sgfId);
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    private static String[] findDataImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return property != null ? property.getStrings() : null;
    }

    public static String findDatum(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        BasicFinder.throwIfMultiType(sgfId);
        for (Node node : sequence) {
            String string = BasicFinder.findDatumImpl(node, sgfId);
            if ("".equals(string)) continue;
            return string;
        }
        return "";
    }

    public static String findDatum(Node node, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)node, (Object)sgfId);
        BasicFinder.throwIfMultiType(sgfId);
        return BasicFinder.findDatumImpl(node, sgfId);
    }

    private static String findDatumImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return property != null ? property.getString() : "";
    }

    private static void throwIfMultiType(SgfId sgfId) {
        if (!CardinalityType.SINGLE.equals((Object)sgfId.cardinalityType())) {
            throw new IllegalArgumentException("Bad type. " + sgfId.id() + " is LIST or ELIST.");
        }
    }

    public static SgfColor firstMove(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        return BasicFinder.firstMoveImpl(rootGameTree);
    }

    private static SgfColor firstMoveImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            if (node.contains(SgfId.WHITE)) {
                return SgfColor.WHITE;
            }
            if (!node.contains(SgfId.BLACK)) continue;
            return SgfColor.BLACK;
        }
        if (gameTree.getChildrenSize() == 0) {
            return null;
        }
        return BasicFinder.firstMoveImpl(gameTree.getChild(0));
    }

    public static List<Property> findAll(GameTree gameTree, SgfId sgfId) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        BasicFinder.findAllImpl(arrayList, gameTree, sgfId);
        return arrayList;
    }

    private static void findAllImpl(List<Property> list, GameTree gameTree, SgfId sgfId) {
        for (Node node : gameTree.getSequence()) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            list.add(property);
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            BasicFinder.findAllImpl(list, gameTree2, sgfId);
        }
    }

    protected BasicFinder() {
    }
}

