/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLapsed
implements TypedString<TimeLapsed> {
    private static final Log log_s_ = LogFactory.getLog(TimeLapsed.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\d+)\\s*,\\s*(\\d+)");
    private static final int TIME_LAPSED_POS = 1;
    private static final int TIME_DELAY_POS = 2;
    private final int timeLapsed_;
    private final int timeDelay_;

    public static TimeLapsed parse(String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)string);
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        return new TimeLapsed(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    public static TimeLapsed parseQuietly(String string) {
        try {
            return TimeLapsed.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.log(LogLevel.DEBUG, typeParseException, "Parse failure: {0}", string);
            return null;
        }
    }

    public TimeLapsed(int n, int n2) {
        this.timeLapsed_ = n;
        this.timeDelay_ = n2;
    }

    public int getTimeLapsed() {
        return this.timeLapsed_;
    }

    public int getTimeDelay() {
        return this.timeDelay_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.TIME_LAPSED);
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.timeLapsed_).append(',').append(this.timeDelay_);
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(TimeLapsed timeLapsed) {
        int n = this.timeLapsed_ - timeLapsed.timeLapsed_;
        if (n != 0) {
            return n;
        }
        return this.timeDelay_ - timeLapsed.timeDelay_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        TimeLapsed timeLapsed = (TimeLapsed)object;
        return this.timeLapsed_ == timeLapsed.timeLapsed_ && this.timeDelay_ == timeLapsed.timeDelay_;
    }

    public int hashCode() {
        return this.timeLapsed_ * 3607 + this.timeDelay_;
    }
}

