/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfApplication
implements TypedString<SgfApplication> {
    private final String name_;
    private final String version_;

    public static SgfApplication parse(String string) throws TypeParseException {
        if (string == null) {
            throw new TypeParseException();
        }
        return new SgfApplication(string);
    }

    public static SgfApplication create(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        return new SgfApplication(string, string2);
    }

    private SgfApplication(String string, String string2) {
        this.name_ = string;
        this.version_ = string2;
    }

    private SgfApplication(String string) {
        int n = string.indexOf(58);
        if (0 < n) {
            this.name_ = string.substring(0, n);
            this.version_ = string.substring(n + 1);
        } else {
            this.name_ = string;
            this.version_ = null;
        }
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.APPLICATION);
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(this.name_);
        if (this.version_ != null) {
            stringBuilder.append(':').append(this.version_);
        }
        return stringBuilder.toString();
    }

    public String name() {
        return this.name_;
    }

    public String version() {
        return this.version_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        SgfApplication sgfApplication = (SgfApplication)object;
        return sgfApplication.name_.equals(this.name_) && Objects.equalsIncludeNull(sgfApplication.version_, this.version_);
    }

    public int hashCode() {
        return this.name_.hashCode() + 31 * Objects.hashCodeIncludeNull(this.version_);
    }

    @Override
    public int compareTo(SgfApplication sgfApplication) {
        int n = this.name_.compareTo(sgfApplication.name_);
        if (n == 0) {
            n = Objects.compateIncludeNull(this.version_, sgfApplication.version_);
        }
        return n;
    }
}

