/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.search.Searches;
import org.unitarou.sgf.search.Stone;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.filter.RotationMirrorFilter;
import org.unitarou.util.ReversibleFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDbQuery {
    private SgfSize size_ = SgfSize.DEFAULT;
    private final List<Node> targetNodes_ = new ArrayList<Node>();
    private boolean allowColorSwitch_ = true;
    private final List<Node> presetNodes_ = new ArrayList<Node>();
    private boolean ignoreSequence_ = true;
    private int allowableMismatchMoveCount_ = 0;
    private final Map<ReversibleFilter<SgfPoint>, List<Stone>> targetStonesMap_ = new HashMap<ReversibleFilter<SgfPoint>, List<Stone>>();
    private final Map<ReversibleFilter<SgfPoint>, List<Stone>> presetStonesMap_ = new HashMap<ReversibleFilter<SgfPoint>, List<Stone>>();

    public SgfSize getSize() {
        return this.size_;
    }

    public void setSize(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.size_ = sgfSize;
    }

    public List<Node> getTargetNodes() {
        return Collections.unmodifiableList(this.targetNodes_);
    }

    public void setTargetNodes(List<Node> list) {
        ArgumentChecker.throwIfNull(list);
        this.targetNodes_.clear();
        this.targetNodes_.addAll(list);
        this.createStones(this.targetNodes_, this.targetStonesMap_);
    }

    private void createStones(List<Node> list, Map<ReversibleFilter<SgfPoint>, List<Stone>> map) {
        ArrayList<Stone> arrayList = new ArrayList<Stone>();
        for (Node node : list) {
            Searches.appendStone(-1, this.size_, node, arrayList);
        }
        map.clear();
        for (RotationMirrorFilter rotationMirrorFilter : RotationMirrorFilter.values()) {
            ArrayList<Stone> arrayList2 = new ArrayList<Stone>(arrayList.size());
            for (Stone stone : arrayList) {
                SgfPoint sgfPoint = rotationMirrorFilter.filter(stone.sgfPoint_);
                arrayList2.add(new Stone(stone.sgfId_, sgfPoint));
            }
            map.put(rotationMirrorFilter.getFilter(), arrayList2);
        }
    }

    public boolean isAllowColorSwitch() {
        return this.allowColorSwitch_;
    }

    public void setAllowColorSwitch(boolean bl) {
        this.allowColorSwitch_ = bl;
    }

    public boolean isIgnoreSequence() {
        return this.ignoreSequence_;
    }

    public void setIgnoreSequence(boolean bl) {
        this.ignoreSequence_ = bl;
    }

    public int getAllowableMismatchMoveCount() {
        return this.allowableMismatchMoveCount_;
    }

    public void setAllowableMismatchMoveCount(int n) {
        this.allowableMismatchMoveCount_ = n;
    }

    public List<Node> getPresetNodes() {
        return Collections.unmodifiableList(this.presetNodes_);
    }

    public void setPresetNodes(List<Node> list) {
        ArgumentChecker.throwIfNull(list);
        this.presetNodes_.clear();
        this.presetNodes_.addAll(list);
        this.createStones(this.presetNodes_, this.presetStonesMap_);
    }

    Map<ReversibleFilter<SgfPoint>, List<Stone>> getStones() {
        return Collections.unmodifiableMap(this.targetStonesMap_);
    }
}

