/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.search.Stone;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Searches {
    private static final Log log_s_ = LogFactory.getLog(Searches.class);

    static void appendStone(int n, SgfSize sgfSize, Node node, List<Stone> list) {
        HashMap<SgfPoint, Stone> hashMap = new HashMap<SgfPoint, Stone>();
        for (SgfId comparable : new SgfId[]{SgfId.ADD_BLACK, SgfId.ADD_WHITE}) {
            Property property = node.getProperty(comparable);
            if (property == null) continue;
            Set<SgfPoint> set = SgfPoint.parseAsSet(sgfSize, property.getStrings());
            for (SgfPoint sgfPoint : set) {
                hashMap.put(sgfPoint, new Stone(comparable, sgfPoint));
            }
        }
        Property property = node.getProperty(SgfId.ADD_EMPTY);
        if (property != null) {
            Set<SgfPoint> set = SgfPoint.parseAsSet(sgfSize, property.getStrings());
            for (SgfPoint sgfPoint : set) {
                hashMap.remove(sgfPoint);
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new Comparator<Stone>(){

            @Override
            public int compare(Stone stone, Stone stone2) {
                return stone.sgfPoint_.compareTo(stone2.sgfPoint_);
            }
        });
        list.addAll(arrayList);
        for (SgfId sgfId : new SgfId[]{SgfId.BLACK, SgfId.WHITE}) {
            Property property2 = node.getProperty(sgfId);
            if (property2 == null) continue;
            try {
                SgfPoint sgfPoint;
                sgfPoint = SgfPoint.parseMove(sgfSize, property2.getString());
                list.add(new Stone(sgfId, sgfPoint));
            }
            catch (TypeParseException typeParseException) {
                log_s_.log(LogLevel.WARN, "Bad property RGT_ID={0}, property={1}", n, property2);
            }
        }
    }

    static void appendTargetProperties(int n, SgfSize sgfSize, GameTree gameTree, List<Stone> list) {
        for (Node node : gameTree.getSequence()) {
            Searches.appendStone(n, sgfSize, node, list);
        }
        if (gameTree.getChildrenSize() == 0) {
            return;
        }
        Searches.appendTargetProperties(n, sgfSize, gameTree.getChild(0), list);
    }
}

