/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.NioReader;
import org.unitarou.sgf.parser.SgfLog;
import org.unitarou.sgf.parser.SgfParserOption;
import org.unitarou.sgf.parser.SgfParserReader;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfParserCore {
    private static final Message NT_IGNORE_FILEHEAD = new Message(SgfParserCore.class, "ntIgnoreFilehead");
    private static final Message NT_IGNORE_INTER_TREE = new Message(SgfParserCore.class, "ntIgnoreInterTree");
    private static final Message NT_IGNORE_INTER_NODE = new Message(SgfParserCore.class, "ntIgnoreInterNode");
    private static final Message NT_IGNORE_INTER_VALUE = new Message(SgfParserCore.class, "ntIgnoreInterValue");
    private static final Message NT_IGNORE_ID = new Message(SgfParserCore.class, "ntIgnoreId");
    private static final Message NT_IGNORE_EMPTY_ID = new Message(SgfParserCore.class, "ntIgnoreEmptyId");
    private static final Message NT_IGNORE_MULTI_VALUES = new Message(SgfParserCore.class, "ntIgnoreMultiValues");
    private static final Message NT_REMOVE_INVALID_PROPERTY = new Message(SgfParserCore.class, "ntRemoveInvalidIdProperty");
    private static final Message NT_TRIM_ID = new Message(SgfParserCore.class, "ntTrimId");
    private static final Message NT_UNWORKABLE_CHARSET = new Message(SgfParserCore.class, "ntUnworkableCharset");
    private static final Message NT_MISMATCH_CHARSET = new Message(SgfParserCore.class, "ntMismatchCharset");
    private static final Message FMT_WING_OVERTIME = new Message(SgfParserCore.class, "fmtWingOvertime");
    private SgfLog parserLogger_;
    private SgfParserReader reader_;
    private boolean isInputTerminated_;
    private final EnumSet<SgfParserOption> options_;
    private final StringBuilder sharedBuffer_ = new StringBuilder();

    private static boolean isAlphabet(int n) {
        return SgfParserCore.isLargeAlphabet(n) || 97 <= n && n <= 122;
    }

    private static boolean isLargeAlphabet(int n) {
        return 65 <= n && n <= 90;
    }

    private static boolean isWhitespace(int n) {
        return Character.isWhitespace((char)n);
    }

    private static boolean isUtrInSgf(int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 59: 
            case 91: 
            case 93: {
                return false;
            }
        }
        return !SgfParserCore.isAlphabet(n);
    }

    public SgfParserCore() {
        this.parserLogger_ = new SgfLog();
        this.options_ = EnumSet.noneOf(SgfParserOption.class);
    }

    public void setByteBuffer(ByteBuffer byteBuffer, Charset charset) {
        ArgumentChecker.throwIfNull((Object)byteBuffer, (Object)charset);
        this.reader_ = new NioReader(byteBuffer, charset);
    }

    public void setParserLogger(SgfLog sgfLog) {
        ArgumentChecker.throwIfNull((Object)sgfLog);
        this.parserLogger_ = sgfLog;
    }

    public SgfLog getParserLogger() {
        return this.parserLogger_;
    }

    public EnumSet<SgfParserOption> getOptions() {
        return this.options_;
    }

    public void setOptions(EnumSet<SgfParserOption> enumSet) {
        ArgumentChecker.throwIfNull(enumSet);
        this.options_.clear();
        this.options_.addAll(enumSet);
    }

    public boolean parseCollection(Collection collection) throws IOException {
        this.reader_.markRootGameTree();
        while (true) {
            try {
                return this.parseCollectionImpl(collection);
            }
            catch (BadCharsetException badCharsetException) {
                if (badCharsetException.getNewCharset() != null) continue;
                this.writeWarningLog(NT_MISMATCH_CHARSET, "");
                this.reader_.setCharset(this.reader_.getDefaultCharset());
                continue;
            }
            break;
        }
    }

    private boolean parseCollectionImpl(Collection collection) throws IOException, BadCharsetException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!this.hasMoreRootGame(stringBuilder, stringBuilder2)) {
            if (collection.size() != 0) {
                stringBuilder.append((CharSequence)stringBuilder2);
                collection.get(collection.size() - 1).setCloseUtr(stringBuilder.toString());
            }
            return false;
        }
        RootGameTree rootGameTree = new RootGameTree();
        rootGameTree.setOpenUtr(stringBuilder.toString());
        if (this.parseGameTree(rootGameTree, rootGameTree)) {
            collection.addLast(rootGameTree);
            rootGameTree.getSequence().getFirst().setOpenUtr(stringBuilder2.toString());
        }
        rootGameTree.setActualCharset(this.reader_.getCharset());
        SgfArgumentChecker.throwIfInvalid(rootGameTree);
        return true;
    }

    private boolean hasMoreRootGame(StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException, BadCharsetException {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder2.setLength(0);
        int n = 0;
        while (true) {
            this.reader_.mark(1);
            n = this.reader_.read();
            if (n == -1) break;
            if (n == 40) {
                if (!bl2) {
                    bl2 = true;
                    continue;
                }
                stringBuilder.append('(');
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2.setLength(0);
                continue;
            }
            if (bl2 && n == 59) {
                this.reader_.reset();
                bl = true;
                break;
            }
            if (!SgfParserCore.isWhitespace(n)) {
                if (!bl2) {
                    stringBuilder3.append((char)n);
                    stringBuilder.append((char)n);
                    continue;
                }
                if (this.options_.contains((Object)SgfParserOption.PERMIT_NO_START_MARK_IN_RGT) && SgfParserCore.isLargeAlphabet(n)) {
                    this.reader_.reset();
                    bl = true;
                    break;
                }
                bl2 = false;
                stringBuilder.append('(');
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append((char)n);
                stringBuilder2.setLength(0);
                continue;
            }
            if (bl2) {
                stringBuilder2.append((char)n);
                continue;
            }
            stringBuilder.append((char)n);
        }
        if (stringBuilder3.length() != 0) {
            this.writeInfoLog(NT_IGNORE_FILEHEAD, stringBuilder3);
        }
        return bl;
    }

    public boolean parseGameTree(RootGameTree rootGameTree, GameTree gameTree) throws IOException, BadCharsetException {
        Object object;
        this.parseSequence(gameTree.getSequence());
        GameTree gameTree2 = new GameTree();
        while (true) {
            if (!this.hasMoreGameTree((StringBuilder)(object = new StringBuilder()))) {
                assert (((StringBuilder)object).length() == 0 || 0 < ((StringBuilder)object).length() && 0 < gameTree.getChildrenSize()) : "Can't set utr2 in the last node.";
                if (0 >= gameTree.getChildrenSize()) break;
                gameTree.getChild(gameTree.getChildrenSize() - 1).setCloseUtr(((StringBuilder)object).toString());
                break;
            }
            gameTree2.setOpenUtr(((StringBuilder)object).toString());
            if (!this.parseGameTree(rootGameTree, gameTree2)) break;
            gameTree.addGameTree(gameTree2);
            gameTree2 = new GameTree();
        }
        if (gameTree.getSequence().size() != 0) {
            return true;
        }
        if (gameTree.getChildrenSize() == 0) {
            return false;
        }
        object = gameTree.getChild(0);
        gameTree.getSequence().clear();
        gameTree.getSequence().addAll(((GameTree)object).getSequence());
        gameTree.clearGameTree();
        GameTree[] gameTreeArray = ((GameTree)object).getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            gameTree.addGameTree(gameTreeArray[i]);
        }
        return true;
    }

    private boolean hasMoreGameTree(StringBuilder stringBuilder) throws IOException, BadCharsetException {
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        while (true) {
            if ((n = this.reader_.read()) == 40) {
                bl = true;
                break;
            }
            if (n == -1 || n == 41) break;
            if (SgfParserCore.isWhitespace(n)) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append((char)n);
            stringBuilder2.append((char)n);
        }
        if (stringBuilder2.length() != 0) {
            this.writeWarningLog(NT_IGNORE_INTER_TREE, stringBuilder2);
        }
        this.isInputTerminated_ = n == -1;
        return bl;
    }

    public boolean parseSequence(Sequence sequence) throws IOException, BadCharsetException {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = new Node();
        while (this.parseNode(node, stringBuilder)) {
            sequence.addLast(node);
            node = new Node();
        }
        if (sequence.isEmpty()) {
            return false;
        }
        sequence.getLast().setCloseUtr(stringBuilder.toString());
        return true;
    }

    public boolean parseNode(Node node, StringBuilder stringBuilder) throws IOException, BadCharsetException {
        Property property;
        Object object;
        if (!this.hasMoreNode(stringBuilder)) {
            return false;
        }
        node.setOpenUtr(stringBuilder.toString());
        stringBuilder.setLength(0);
        Property property2 = new Property();
        while (this.parseProperty(property2, stringBuilder)) {
            property2.setOpenUtr(stringBuilder.toString());
            object = property2.sgfId();
            property = node.getProperty((SgfId)object);
            if (property != null) {
                if (this.options_.contains((Object)SgfParserOption.MARGE_LIST_PROPERTIES) && !((SgfId)object).cardinalityType().equals((Object)CardinalityType.SINGLE)) {
                    property2.addValue(property.getValues());
                } else if (this.isMargeableTextProperty((SgfId)object)) {
                    Value value = property2.getValue();
                    String string = property.getString() + ' ' + value.getString();
                    property2.setValue(new Value(string, value.getOpenUtr()));
                }
            }
            if (property2.isValid()) {
                node.addProperty(property2);
            }
            property2 = new Property();
            stringBuilder.setLength(0);
        }
        node.setCloseUtr(stringBuilder.toString());
        if (this.options_.contains((Object)SgfParserOption.APPEND_WING_TIME_TO_OT)) {
            if (node.contains(SgfId.OVERTIME)) {
                return true;
            }
            object = node.getProperty(SgfId.OVERTIME_MOVE);
            property = node.getProperty(SgfId.OVERTIME_PERIOD);
            if (object == null || property == null || !((Property)object).isValid() || !property.isValid()) {
                return true;
            }
            node.addProperty(new Property(SgfId.OVERTIME, FMT_WING_OVERTIME.get(((Property)object).getString(), property.getString())));
        }
        return true;
    }

    private boolean isMargeableTextProperty(SgfId sgfId) {
        return this.options_.contains((Object)SgfParserOption.MARGE_TEXT_PROPERTIES) && (sgfId.valueType().equals((Object)ValueType.TEXT) || sgfId.valueType().equals((Object)ValueType.SIMPLE_TEXT)) && sgfId.cardinalityType().equals((Object)CardinalityType.SINGLE);
    }

    private boolean hasMoreNode(StringBuilder stringBuilder) throws IOException, BadCharsetException {
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        while (true) {
            this.reader_.mark(1);
            n = this.reader_.read();
            if (n == 59) {
                bl = true;
                break;
            }
            if (n == -1) break;
            if (n == 40 || n == 41) {
                this.reader_.reset();
                break;
            }
            if (SgfParserCore.isWhitespace(n)) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append((char)n);
            stringBuilder2.append((char)n);
        }
        if (stringBuilder2.length() != 0) {
            this.writeWarningLog(NT_IGNORE_INTER_NODE, stringBuilder2);
        }
        this.isInputTerminated_ = n == -1;
        return bl;
    }

    public boolean parseProperty(Property property, StringBuilder stringBuilder) throws IOException, BadCharsetException {
        Comparable<Charset> comparable;
        Object object;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = this.parseIdentifier(stringBuilder, stringBuilder2);
        if (!Sgfs.isValidEntireId(string)) {
            return false;
        }
        property.setEntireId(string);
        this.parseValues(property, stringBuilder2);
        if (property.size() == 0) {
            return false;
        }
        if (!property.sgfId().permitsMultiValues() && property.size() != 1) {
            int n;
            object = property.getValues();
            comparable = new StringBuilder(property.getEntireId());
            for (n = 0; n < ((Value[])object).length; ++n) {
                ((StringBuilder)comparable).append(object[n].toString()).append(' ');
            }
            this.writeWarningLog(NT_IGNORE_MULTI_VALUES, ((StringBuilder)comparable).toString());
            if (this.isMargeableTextProperty(property.sgfId())) {
                ((StringBuilder)comparable).setLength(0);
                for (n = 0; n < ((Value[])object).length; ++n) {
                    ((StringBuilder)comparable).append(object[n].getString()).append(' ');
                }
                property.setValue(new Value((CharSequence)((Object)comparable)));
            } else {
                property.setValue(object[0]);
            }
        }
        if (property.sgfId().equals(SgfId.CHARSET)) {
            object = property.getString();
            try {
                comparable = Charset.forName((String)object);
                if (this.reader_.setCharset((Charset)comparable)) {
                    throw new BadCharsetException((Charset)comparable);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.parserLogger_.warn(this.reader_.getLineNumber(), NT_UNWORKABLE_CHARSET.get(object), property.toString());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.parserLogger_.warn(this.reader_.getLineNumber(), NT_UNWORKABLE_CHARSET.get(object), property.toString());
            }
        }
        if (this.options_.contains((Object)SgfParserOption.CORRECT_RIGHT_DIGIT) && property.sgfId().valueType().isNumeric()) {
            object = new ArrayList(property.size());
            for (Comparable<Charset> comparable2 : property.getValues()) {
                String string2 = ((Value)((Object)comparable2)).getString();
                string2 = Strings.replaceFullwidthDigit(string2);
                object.add(new Value(string2, ((Value)((Object)comparable2)).getOpenUtr()));
            }
            property.clearValue();
            if (property.sgfId().permitsMultiValues()) {
                property.addValue(object.toArray(new Value[object.size()]));
            } else {
                property.addValue((Value)object.get(0));
            }
        }
        if (!property.isValid()) {
            this.writeWarningLog(NT_REMOVE_INVALID_PROPERTY, property);
        }
        return true;
    }

    public String parseIdentifier(StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException, BadCharsetException {
        String string = null;
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        int n = 0;
        while (true) {
            this.reader_.mark(1);
            n = this.reader_.read();
            if (SgfParserCore.isAlphabet(n)) {
                stringBuilder4.append((char)n);
                continue;
            }
            if (n == 91) {
                string = stringBuilder4.toString().trim();
                if (string.length() == 0) {
                    this.writeWarningLog(NT_IGNORE_EMPTY_ID, "");
                    stringBuilder.append((CharSequence)stringBuilder4);
                    stringBuilder.append((char)n);
                    stringBuilder4.setLength(0);
                    continue;
                }
                String string2 = stringBuilder4.toString();
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
                int n2 = stringCharacterIterator.last();
                while (n2 != 65535 && Character.isWhitespace((char)n2)) {
                    stringBuilder2.insert(0, (char)n2);
                    n2 = stringCharacterIterator.previous();
                }
                n2 = -1;
                StringCharacterIterator stringCharacterIterator2 = new StringCharacterIterator(string);
                char c = stringCharacterIterator2.last();
                while (c != '\uffff') {
                    if (Character.isWhitespace(c)) {
                        n2 = stringCharacterIterator2.getIndex();
                        break;
                    }
                    c = stringCharacterIterator2.previous();
                }
                if (0 <= n2) {
                    this.writeWarningLog(NT_TRIM_ID, string);
                    string = string.substring(n2).trim();
                }
                stringBuilder.append(string2.substring(0, string2.lastIndexOf(string)));
                break;
            }
            if (n == -1 || n == 40 || n == 41 || n == 59) {
                this.reader_.reset();
                this.isInputTerminated_ = n == -1;
                stringBuilder.append((CharSequence)stringBuilder4);
                break;
            }
            if (SgfParserCore.isWhitespace(n)) {
                stringBuilder4.append((char)n);
                continue;
            }
            stringBuilder.append((CharSequence)stringBuilder4);
            stringBuilder.append((char)n);
            stringBuilder4.setLength(0);
            stringBuilder3.append((char)n);
        }
        if (stringBuilder3.length() != 0) {
            this.writeWarningLog(NT_IGNORE_ID, stringBuilder3);
        }
        return string;
    }

    public void parseValues(Property property, StringBuilder stringBuilder) throws IOException, BadCharsetException {
        int n = 0;
        Value value = this.parseValue(property.sgfId().valueType());
        while (value != null) {
            String string = value.toString();
            value = this.correctLabel(property.sgfId(), value, n);
            if (value != null) {
                property.addValue(new Value(value.getString(), stringBuilder.toString()));
            } else {
                String string2 = property.getEntireId() + '[' + string + ']';
                this.writeWarningLog(NT_REMOVE_INVALID_PROPERTY, string2);
            }
            stringBuilder.setLength(0);
            value = this.hasMoreValue(stringBuilder) ? this.parseValue(property.sgfId().valueType()) : null;
            ++n;
        }
        property.setCloseUtr(stringBuilder.toString());
    }

    public Value parseValue(ValueType valueType) throws IOException, BadCharsetException {
        this.sharedBuffer_.setLength(0);
        while (true) {
            this.reader_.mark(1);
            int n = this.reader_.read();
            if (n == -1) {
                this.isInputTerminated_ = true;
                return null;
            }
            if (n == 93) {
                CharSequence charSequence;
                String string = this.sharedBuffer_.toString();
                switch (valueType) {
                    case TEXT: {
                        charSequence = Sgfs.unescapeTextForRead(string);
                        break;
                    }
                    case SIMPLE_TEXT: {
                        charSequence = Sgfs.unescapeSimpleTextForRead(string);
                        break;
                    }
                    case OTHER: {
                        charSequence = Sgfs.unespaceForRead(this.sharedBuffer_);
                        break;
                    }
                    default: {
                        charSequence = string;
                    }
                }
                return new Value(charSequence);
            }
            if (n == 92) {
                this.sharedBuffer_.append((char)n);
                n = (char)this.reader_.read();
                if (n == -1) {
                    this.isInputTerminated_ = true;
                    return null;
                }
            }
            this.sharedBuffer_.append((char)n);
        }
    }

    private Value correctLabel(SgfId sgfId, Value value, int n) {
        if (!SgfId.LABEL.equals(sgfId)) {
            return value;
        }
        String string = value.getString();
        int n2 = string.indexOf(58);
        if (n2 == -1 && this.options_.contains((Object)SgfParserOption.CORRECT_INVALID_LABEL)) {
            n2 = value.getString().indexOf(32);
        }
        if (n2 == -1) {
            return null;
        }
        if (n2 + 1 != string.length()) {
            string = string.substring(0, n2).trim() + ':' + string.substring(n2 + 1).trim();
        } else if (this.options_.contains((Object)SgfParserOption.CORRECT_EMPTY_LABEL)) {
            string = string.trim() + String.valueOf((char)(97 + n));
        }
        try {
            String[] stringArray = Label.parseString(string);
            return new Value(stringArray[0] + ':' + stringArray[1]);
        }
        catch (TypeParseException typeParseException) {
            return null;
        }
    }

    private boolean hasMoreValue(StringBuilder stringBuilder) throws IOException, BadCharsetException {
        int n;
        boolean bl;
        block2: {
            bl = false;
            while (true) {
                this.reader_.mark(1);
                n = this.reader_.read();
                if (n == 91) {
                    bl = true;
                    break block2;
                }
                if (n == -1) break block2;
                if (!SgfParserCore.isUtrInSgf(n)) break;
                stringBuilder.append((char)n);
            }
            this.reader_.reset();
        }
        this.isInputTerminated_ = n == -1;
        return bl;
    }

    public void writeWarningLog(Message message, Object object) {
        this.parserLogger_.warn(this.reader_.getLineNumber(), message.get(), object.toString());
    }

    public void writeInfoLog(Message message, Object object) {
        this.parserLogger_.info(this.reader_.getLineNumber(), message.get(), object.toString());
    }

    public boolean isInputTerminated() {
        return this.isInputTerminated_;
    }

    public void setInputTerminated(boolean bl) {
        this.isInputTerminated_ = bl;
    }
}

