/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfLog {
    private final List<SgfMessage> sgfMessages_;

    public SgfLog() {
        this.sgfMessages_ = new ArrayList<SgfMessage>();
    }

    public SgfLog(SgfLog sgfLog) {
        ArgumentChecker.throwIfNull((Object)sgfLog);
        this.sgfMessages_ = new ArrayList<SgfMessage>(sgfLog.sgfMessages_);
    }

    public void addMessage(SgfMessage sgfMessage) {
        ArgumentChecker.throwIfNull((Object)sgfMessage);
        this.sgfMessages_.add(sgfMessage);
    }

    public void log(LogLevel logLevel, int n, String string, String string2) {
        this.addMessage(new SgfMessage(logLevel, n, string, string2));
    }

    public void error(int n, String string, String string2) {
        this.addMessage(new SgfMessage(LogLevel.ERROR, n, string, string2));
    }

    public void warn(int n, String string, String string2) {
        this.addMessage(new SgfMessage(LogLevel.WARN, n, string, string2));
    }

    public void info(int n, String string, String string2) {
        this.addMessage(new SgfMessage(LogLevel.INFO, n, string, string2));
    }

    public List<SgfMessage> getMessages(LogLevel logLevel) {
        ArgumentChecker.throwIfNull((Object)logLevel);
        ArrayList<SgfMessage> arrayList = new ArrayList<SgfMessage>(this.sgfMessages_.size());
        for (int i = 0; i < this.sgfMessages_.size(); ++i) {
            SgfMessage sgfMessage = this.sgfMessages_.get(i);
            if (logLevel.getRank() < sgfMessage.level_.getRank()) continue;
            arrayList.add(sgfMessage);
        }
        return arrayList;
    }

    public List<SgfMessage> getAllMessages() {
        return new ArrayList<SgfMessage>(this.sgfMessages_);
    }

    public static class SgfMessage {
        private final LogLevel level_;
        private final int line_;
        private final String message_;
        private final String fragment_;
        private String toString_;

        public SgfMessage(LogLevel logLevel, int n, String string, String string2) {
            ArgumentChecker.throwIfNull((Object)logLevel, (Object)string, (Object)string2);
            this.level_ = logLevel;
            this.line_ = n;
            this.message_ = string;
            this.fragment_ = string2;
            this.toString_ = null;
        }

        public LogLevel getLevel() {
            return this.level_;
        }

        public int getLine() {
            return this.line_;
        }

        public String getMessage() {
            return this.message_;
        }

        public String getFragment() {
            return this.fragment_;
        }

        public String toString() {
            if (this.toString_ != null) {
                return this.toString_;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.level_).append('@').append(this.line_).append('\'').append(Strings.escapeLineSaparator(this.fragment_)).append('\'').append('/').append(Strings.escapeLineSaparator(this.message_));
            this.toString_ = stringBuilder.toString();
            return this.toString_;
        }
    }
}

