/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;

public class RemoveProperty
extends AbstractCommand {
    private final Node node_;
    private final Property[] properties_;
    private final SgfId id_;
    private Property removed_;

    public RemoveProperty(Node node, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)node, (Object)sgfId);
        this.node_ = node;
        this.properties_ = this.node_.getProperties();
        this.id_ = sgfId;
        this.removed_ = null;
    }

    protected void executeCommand() {
        this.removed_ = this.node_.removeProperty(this.id_);
        if (this.removed_ == null) {
            throw new IllegalStateException("Cannot remove property. property = " + this.id_);
        }
    }

    protected void undoCommand() {
        int n;
        for (n = 0; n < this.properties_.length; ++n) {
            this.node_.removeProperty(this.properties_[n].sgfId());
        }
        for (n = 0; n < this.properties_.length; ++n) {
            this.node_.addProperty(this.properties_[n]);
        }
        this.removed_ = null;
    }
}

