/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.RemoveGameTree;

public class RemoveLastNode
extends AbstractCommand {
    private final GameTree target_;
    private final GameTree parent_;
    private Node node_;
    private RemoveGameTree removeGameTree_;

    public RemoveLastNode(GameTree gameTree) {
        if (gameTree == null) {
            throw new NullPointerException("Argument(target) must not be null. ");
        }
        if (gameTree.getChildren().length != 0) {
            throw new IllegalArgumentException("A target must not have any children.");
        }
        this.target_ = gameTree;
        this.parent_ = gameTree.getParent();
        this.node_ = null;
        this.removeGameTree_ = null;
    }

    protected void executeCommand() {
        this.node_ = this.target_.getSequence().removeLast();
        if (this.node_ == null) {
            throw new IllegalStateException("Cannot remove the last node. ");
        }
        if (this.target_.getSequence().size() == 0 && this.parent_ != null) {
            this.removeGameTree_ = new RemoveGameTree(this.parent_, this.target_);
            this.removeGameTree_.execute();
        }
    }

    protected void undoCommand() {
        this.target_.getSequence().addLast(this.node_);
        if (this.removeGameTree_ != null) {
            this.removeGameTree_.undo();
            this.removeGameTree_ = null;
        }
        this.node_ = null;
    }
}

