/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointSet;
import org.unitarou.sgf.util.SgfRectangle;

public class EditProperty
extends AbstractCommand {
    public static final EditType ADD_OR_REPLACE = new EditType("Add or replace");
    public static final EditType DELETE = new EditType("Delete");
    private final Node node_;
    private final Property target_;
    private final Property backup_;
    private final EditType editType_;

    public EditProperty(Node node, Property property, EditType editType) {
        ArgumentChecker.throwIfNull((Object)node, (Object)property, (Object)editType);
        this.node_ = node;
        this.target_ = property;
        this.backup_ = this.node_.getProperty(this.target_.sgfId());
        this.editType_ = editType;
    }

    public EditType getEditType() {
        return this.editType_;
    }

    public SgfId getSgfId() {
        return this.target_.sgfId();
    }

    protected void executeCommand() {
        if (this.backup_ == null) {
            if (ADD_OR_REPLACE.equals(this.editType_)) {
                this.node_.addProperty(this.target_);
            }
            return;
        }
        CardinalityType cardinalityType = this.target_.sgfId().cardinalityType();
        if (CardinalityType.SINGLE.equals((Object)cardinalityType)) {
            if (ADD_OR_REPLACE.equals(this.editType_)) {
                this.node_.addProperty(this.target_);
            } else if (DELETE.equals(this.editType_)) {
                this.node_.removeProperty(this.target_.sgfId());
            }
            return;
        }
        if (CardinalityType.LIST.equals((Object)cardinalityType)) {
            this.editList();
            return;
        }
        if (CardinalityType.ELIST.equals((Object)cardinalityType)) {
            this.editEList();
            return;
        }
        assert (false) : "Unknown cardinality : " + (Object)((Object)cardinalityType);
    }

    private void editList() {
        ValueType valueType = this.target_.sgfId().valueType();
        if (ValueType.POINT.equals((Object)valueType)) {
            this.editListByPoint();
        } else if (SgfId.LABEL.equals(this.target_.sgfId())) {
            this.editListByLabel();
        } else {
            this.editListByOther();
        }
    }

    private void editEList() {
        for (String string : this.target_.getStrings()) {
            if (!"".equals(string)) continue;
            this.node_.removeProperty(this.target_.sgfId());
            this.node_.addProperty(this.target_);
            return;
        }
        ValueType valueType = this.target_.sgfId().valueType();
        if (ValueType.POINT.equals((Object)valueType)) {
            this.editListByPoint();
        } else {
            this.editListByOther();
        }
    }

    private void editListByPoint() {
        SgfPointSet sgfPointSet = new SgfPointSet();
        sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, this.backup_.getStrings()));
        if (ADD_OR_REPLACE.equals(this.editType_)) {
            sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, this.target_.getStrings()));
        } else if (DELETE.equals(this.editType_)) {
            int n = sgfPointSet.size();
            sgfPointSet.remove(SgfPoint.parse(SgfSize.MAX, this.target_.getStrings()));
            if (n == sgfPointSet.size()) {
                return;
            }
            if (sgfPointSet.isEmpty()) {
                this.node_.removeProperty(this.target_.sgfId());
                return;
            }
        }
        Property property = new Property();
        property.setId(this.backup_.getId());
        SgfRectangle[] sgfRectangleArray = sgfPointSet.getRegularRectangles();
        for (int i = 0; i < sgfRectangleArray.length; ++i) {
            property.addValue(new Value(sgfRectangleArray[i].getValue()));
        }
        this.node_.addProperty(property);
    }

    private void editListByLabel() {
        Property property = new Property(this.backup_);
        String[] stringArray = this.target_.getStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            try {
                Value[] valueArray;
                String string = Label.parseString(stringArray[i])[0];
                for (Value value : valueArray = property.getValues()) {
                    String string2 = Label.parseString(value.getString())[0];
                    if (!string.equals(string2)) continue;
                    property.removeValue(value);
                    if (ADD_OR_REPLACE.equals(this.editType_)) {
                        property.addValue(new Value(stringArray[i], value.getOpenUtr()));
                    }
                    bl = true;
                    break;
                }
                if (bl || !ADD_OR_REPLACE.equals(this.editType_)) continue;
                property.addValue(new Value(stringArray[i]));
                continue;
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        if (property.size() == 0) {
            this.node_.removeProperty(property.sgfId());
        } else {
            this.node_.addProperty(property);
        }
    }

    private void editListByOther() {
        Property property = new Property(this.backup_);
        Value[] valueArray = this.target_.getValues();
        for (int i = 0; i < valueArray.length; ++i) {
            property.removeValue(valueArray[i]);
        }
        if (ADD_OR_REPLACE.equals(this.editType_)) {
            property.addValue(this.target_.getValues());
        }
        this.node_.removeProperty(property.sgfId());
        if (property.size() != 0) {
            this.node_.addProperty(property);
        }
    }

    protected void undoCommand() {
        if (this.backup_ == null) {
            this.node_.removeProperty(this.target_.sgfId());
        } else {
            this.node_.addProperty(this.backup_);
        }
    }

    public static class EditType
    extends UEnum {
        protected EditType(String string) {
            super(string);
        }
    }
}

