/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;

public class AddGameTree
extends AbstractCommand {
    private final GameTree target_;
    private final GameTree child_;
    private Node additionPoint_;
    private boolean appendAsSequence_;

    public AddGameTree(GameTree gameTree, GameTree gameTree2) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)gameTree2);
        this.target_ = gameTree;
        this.child_ = gameTree2;
        this.additionPoint_ = null;
    }

    protected void executeCommand() {
        if (0 < this.target_.getChildren().length) {
            this.target_.addGameTree(this.child_);
            this.appendAsSequence_ = false;
        } else {
            Sequence sequence = this.target_.getSequence();
            this.appendAsSequence_ = true;
            this.additionPoint_ = sequence.getLast();
            for (Node node : this.child_.getSequence()) {
                this.target_.getSequence().addLast(node);
            }
            for (GameTree gameTree : this.child_.getChildren()) {
                this.target_.addGameTree(gameTree);
            }
        }
    }

    protected void undoCommand() {
        if (!this.appendAsSequence_) {
            this.target_.removeGameTree(this.child_);
        } else {
            Node node = this.target_.getSequence().removeLast();
            while (node != this.additionPoint_) {
                node = this.target_.getSequence().removeLast();
            }
            if (this.additionPoint_ != null) {
                this.target_.getSequence().addLast(node);
            }
            for (GameTree gameTree : this.target_.getChildren()) {
                this.child_.addGameTree(gameTree);
            }
            this.additionPoint_ = null;
        }
    }
}

