/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.nio.charset.Charset;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.InvalidSgfStateException;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfApplication;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.SgfArgumentChecker;

public class RootGameTree
extends GameTree {
    private Charset actualCharset_;
    private SgfSize sgfSize_ = null;
    private Style style_ = null;
    private GameType gameType_ = null;

    public RootGameTree() {
        this.actualCharset_ = null;
    }

    public RootGameTree(RootGameTree rootGameTree) {
        super(rootGameTree);
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.actualCharset_ = rootGameTree.actualCharset_;
        SgfArgumentChecker.throwIfInvalid(this);
    }

    public Charset getActualCharset() {
        return this.actualCharset_ != null ? this.actualCharset_ : Charset.defaultCharset();
    }

    public void setActualCharset(Charset charset) {
        this.actualCharset_ = charset;
    }

    public void setApplication(SgfApplication sgfApplication) {
        ArgumentChecker.throwIfNull((Object)sgfApplication);
        this.clearRootProperty(SgfId.APPLICATION);
        Sequence sequence = this.getSequence();
        Node node = sequence.isEmpty() ? new Node() : sequence.getFirst();
        node.addProperty(SgfId.APPLICATION.makeProperty(sgfApplication));
    }

    public void setFileFormat(FileFormat fileFormat) {
        ArgumentChecker.throwIfNull((Object)fileFormat);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.FILE_FORMAT);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.FILE_FORMAT.makeProperty(fileFormat));
    }

    public void setCharset(SgfCharset sgfCharset) {
        ArgumentChecker.throwIfNull((Object)sgfCharset);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.CHARSET);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.CHARSET.makeProperty(sgfCharset));
    }

    public void setGameMode(GameMode gameMode) {
        ArgumentChecker.throwIfNull((Object)gameMode);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.GAME_MODE);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.GAME_MODE.makeProperty(gameMode));
    }

    public void setSize(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.sgfSize_ = sgfSize;
        this.getRootNode().addProperty(SgfId.SIZE.makeProperty(sgfSize));
    }

    public void setStyle(Style style) {
        ArgumentChecker.throwIfNull((Object)style);
        this.style_ = style;
        this.getRootNode().addProperty(SgfId.STYLE.makeProperty(style));
    }

    public void setGameType(GameType gameType) {
        ArgumentChecker.throwIfNull((Object)gameType);
        this.gameType_ = gameType;
        this.getRootNode().addProperty(new Property("GTT", gameType.getString()));
    }

    public Node getRootNode() {
        Node node;
        Sequence sequence = this.getSequence();
        if (sequence.isEmpty()) {
            node = new Node();
            sequence.addFirst(node);
        } else {
            node = sequence.getFirst();
        }
        return node;
    }

    public SgfApplication getApplication() {
        String string = BasicFinder.findDatum(this.getSequence(), SgfId.APPLICATION);
        if ("".equals(string)) {
            return null;
        }
        try {
            return SgfApplication.parse(string);
        }
        catch (TypeParseException typeParseException) {
            return null;
        }
    }

    public FileFormat getFileFormat() {
        Property property = this.findInRoot(SgfId.FILE_FORMAT);
        if (property == null) {
            return FileFormat.VERSION_4;
        }
        try {
            return FileFormat.parse(property.getString());
        }
        catch (TypeParseException typeParseException) {
            return FileFormat.VERSION_4;
        }
    }

    public SgfCharset getSgfCharset() {
        Property property = this.findInRoot(SgfId.CHARSET);
        if (property == null) {
            return null;
        }
        return SgfCharset.parse(property.getString());
    }

    public GameMode getGameMode() {
        Property property = this.findInRoot(SgfId.GAME_MODE);
        if (property == null) {
            return GameMode.IGO;
        }
        return GameMode.parse(property.getString());
    }

    public SgfSize getSize() {
        if (this.sgfSize_ != null) {
            return this.sgfSize_;
        }
        try {
            Property property = this.findInRoot(SgfId.SIZE);
            this.sgfSize_ = property == null ? SgfSize.DEFAULT : SgfSize.parse(property.getString());
            return this.sgfSize_;
        }
        catch (TypeParseException typeParseException) {
            throw new InvalidSgfStateException(typeParseException);
        }
    }

    public Style getStyle() {
        if (this.style_ != null) {
            return this.style_;
        }
        Property property = this.findInRoot(SgfId.STYLE);
        if (property != null) {
            this.style_ = Style.parse(property.getString());
        }
        this.style_ = this.style_ == null ? Style.DEFAULT : this.style_;
        return this.style_;
    }

    public GameType getGameType() {
        if (this.gameType_ != null) {
            return this.gameType_;
        }
        Property property = this.findInRoot(SgfId.GAME_TYPE);
        if (property == null) {
            this.gameType_ = GameType.GAME;
        } else {
            try {
                this.gameType_ = GameType.parse(property.getString());
            }
            catch (TypeParseException typeParseException) {
                this.gameType_ = GameType.GAME;
            }
        }
        return this.gameType_;
    }

    private Property findInRoot(SgfId sgfId) {
        if (this.getSequence().isEmpty()) {
            return null;
        }
        return this.getSequence().getFirst().getProperty(sgfId);
    }

    private void clearRootProperty(SgfId sgfId) {
        Sequence sequence = this.getSequence();
        if (sequence.isEmpty()) {
            return;
        }
        sequence.getFirst().removeProperty(sgfId);
    }

    public void clearPropertyCache() {
        this.sgfSize_ = null;
        this.style_ = null;
        this.gameType_ = null;
    }
}

