/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Property {
    private String entireId_;
    private SgfId sgfId_;
    private final LinkedHashMap<String, Value> valueMap_;
    private String openUtr_;
    private String closeUtr_;
    private int hashCode_;

    public Property() {
        this.entireId_ = "";
        this.sgfId_ = SgfId.find("");
        this.valueMap_ = new LinkedHashMap(1);
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
    }

    public Property(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        this.entireId_ = property.entireId_;
        this.sgfId_ = property.sgfId_;
        this.valueMap_ = new LinkedHashMap<String, Value>(property.valueMap_);
        this.openUtr_ = property.openUtr_;
        this.closeUtr_ = property.closeUtr_;
        this.hashCode_ = property.hashCode_;
    }

    public Property(SgfId sgfId, String string) {
        ArgumentChecker.throwIfNull((Object)sgfId, (Object)string);
        this.entireId_ = sgfId.id();
        this.sgfId_ = sgfId;
        this.valueMap_ = new LinkedHashMap(1);
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
        if (this.sgfId_.permitsMultiValues()) {
            this.addValue(new Value(string));
        } else {
            this.setValue(new Value(string));
        }
    }

    public Property(SgfId sgfId, Collection<SgfPoint> collection) {
        ArgumentChecker.throwIfNull((Object)sgfId, collection);
        if (!sgfId.permitsMultiValues()) {
            throw new IllegalArgumentException("Invalid type: " + sgfId);
        }
        this.entireId_ = sgfId.id();
        this.sgfId_ = sgfId;
        this.valueMap_ = new LinkedHashMap(collection.size());
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
        for (SgfPoint sgfPoint : collection) {
            this.addValue(new Value(sgfPoint.getString()));
        }
    }

    public Property(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        if (!Sgfs.isValidEntireId(string)) {
            throw new IllegalArgumentException("Invalid entireId = " + string);
        }
        this.entireId_ = string;
        this.sgfId_ = SgfId.find(string);
        this.valueMap_ = new LinkedHashMap(1);
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
        if (this.sgfId_.permitsMultiValues()) {
            this.addValue(new Value(string2));
        } else {
            this.setValue(new Value(string2));
        }
    }

    public void setId(String string) {
        if (!Sgfs.isValidId(string)) {
            throw new IllegalArgumentException("Bad id = " + string);
        }
        this.entireId_ = string;
        this.sgfId_ = SgfId.find(string);
        this.hashCode_ = 0;
        this.singularizeIfNeeds();
    }

    public void setEntireId(String string) {
        if (!Sgfs.isValidEntireId(string)) {
            throw new IllegalArgumentException("Bad entireId='" + string + "'");
        }
        this.entireId_ = string;
        this.sgfId_ = SgfId.find(string);
        this.hashCode_ = 0;
        this.singularizeIfNeeds();
    }

    public void clear() {
        this.entireId_ = "";
        this.sgfId_ = SgfId.find("");
        this.valueMap_.clear();
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
    }

    public void setValue(Value value) {
        this.checkValue(value, false);
        this.valueMap_.clear();
        this.valueMap_.put(value.getString(), value);
        this.hashCode_ = 0;
    }

    public int addValue(Value[] valueArray) {
        this.checkValue(valueArray, true);
        this.hashCode_ = 0;
        if (this.sgfId_.cardinalityType().equals((Object)CardinalityType.ELIST) && valueArray.length != 0) {
            if (valueArray[0].isEmpty()) {
                this.valueMap_.clear();
                this.valueMap_.put(valueArray[0].getString(), new Value(valueArray[0]));
                return 1;
            }
            this.valueMap_.remove("");
        }
        int n = 0;
        for (int i = 0; i < valueArray.length; ++i) {
            if (this.valueMap_.containsKey(valueArray[i].getString())) continue;
            this.valueMap_.put(valueArray[i].getString(), new Value(valueArray[i]));
            ++n;
        }
        return n;
    }

    public void addValue(Value value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.hashCode_ = 0;
        if (this.sgfId_.cardinalityType().equals((Object)CardinalityType.ELIST)) {
            if (value.isEmpty()) {
                this.valueMap_.clear();
            }
            this.valueMap_.remove("");
        }
        this.valueMap_.put(value.getString(), value);
    }

    public boolean removeValue(Value value) {
        this.checkValue(value, true);
        this.hashCode_ = 0;
        return this.valueMap_.remove(value.getString()) != null;
    }

    public void singularizeIfNeeds() {
        if (1 < this.valueMap_.size() && !this.sgfId_.permitsMultiValues()) {
            Value value = this.valueMap_.values().toArray(new Value[this.valueMap_.size()])[0];
            this.valueMap_.clear();
            this.valueMap_.put(value.getString(), value);
            this.hashCode_ = 0;
        }
    }

    public void clearValue() {
        this.valueMap_.clear();
        this.hashCode_ = 0;
    }

    public void setOpenUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.openUtr_ = string;
        this.hashCode_ = 0;
    }

    public void setCloseUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.closeUtr_ = string;
        this.hashCode_ = 0;
    }

    public String getId() {
        return this.sgfId_.id();
    }

    public String getEntireId() {
        return this.entireId_;
    }

    public SgfId sgfId() {
        return this.sgfId_;
    }

    public boolean isValid() {
        if (!Sgfs.isValidEntireId(this.entireId_)) {
            return false;
        }
        switch (this.valueMap_.size()) {
            case 0: {
                return false;
            }
            case 1: {
                Value value = this.valueMap_.values().iterator().next();
                return !ValueType.NONE.equals((Object)this.sgfId_.valueType()) || value.isEmpty();
            }
        }
        return this.sgfId_.cardinalityType().permitsMultiValues();
    }

    public String toSgf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.openUtr_);
        stringBuilder.append(this.entireId_);
        for (Value value : this.valueMap_.values()) {
            stringBuilder.append(value.getOpenUtr());
            stringBuilder.append('[');
            stringBuilder.append(Sgfs.escapeForStore(value.getString()));
            stringBuilder.append(']');
        }
        stringBuilder.append(this.closeUtr_);
        return stringBuilder.toString();
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean contains(SgfId sgfId, String string) {
        ArgumentChecker.throwIfNull((Object)sgfId, (Object)string);
        if (!sgfId.equals(this.sgfId_)) {
            return false;
        }
        return this.contains(string);
    }

    private void checkValue(Object object, boolean bl) {
        ArgumentChecker.throwIfNull(object);
        if (bl != this.sgfId_.permitsMultiValues()) {
            throw new IllegalStateException("type_.getCardinalityType() is :" + (Object)((Object)this.sgfId_.cardinalityType()));
        }
    }

    public String getString() {
        return this.getValue().getString();
    }

    public String[] getStrings() {
        String[] stringArray = new String[this.valueMap_.size()];
        int n = 0;
        for (Value value : this.valueMap_.values()) {
            stringArray[n] = value.getString();
            ++n;
        }
        return stringArray;
    }

    public boolean contains(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.valueMap_.containsKey(string);
    }

    public Value getValue() {
        this.checkValue(this, false);
        return new Value(this.valueMap_.values().iterator().next());
    }

    public Value[] getValues() {
        Value[] valueArray = new Value[this.valueMap_.size()];
        int n = 0;
        for (Value value : this.valueMap_.values()) {
            valueArray[n] = new Value(value);
            ++n;
        }
        return valueArray;
    }

    public int size() {
        return this.valueMap_.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Property property = (Property)object;
        return this.sgfId_.equals(property.sgfId_) && this.valueMap_.equals(property.valueMap_) && this.openUtr_.equals(property.openUtr_) && this.closeUtr_.equals(property.closeUtr_);
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = this.sgfId_.hashCode() * 5 + this.valueMap_.hashCode() * 7 + this.openUtr_.hashCode() * 11 + this.closeUtr_.hashCode() * 13;
        }
        return this.hashCode_;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.openUtr_);
        stringBuilder.append(this.entireId_);
        if (this.valueMap_.isEmpty()) {
            return "<<EMPTY>>";
        }
        for (Value value : this.valueMap_.values()) {
            stringBuilder.append('[').append(value.getString()).append(']');
        }
        stringBuilder.append(this.closeUtr_);
        return stringBuilder.toString();
    }
}

