/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final Properties properties_;
    private String openUtr_;
    private String closeUtr_;
    private int hashCode_;

    public static Node makeMoveNode(SgfColor sgfColor, SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfColor, (Object)sgfPoint);
        Property property = sgfColor.moveType().makeProperty(sgfPoint);
        Node node = new Node();
        node.properties_.add(property);
        return node;
    }

    public Node() {
        this.properties_ = new Properties();
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
    }

    public Node(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        this.properties_ = new Properties(node.properties_);
        this.openUtr_ = node.openUtr_;
        this.closeUtr_ = node.closeUtr_;
        this.hashCode_ = node.hashCode_;
    }

    public Node(Property property) {
        this();
        if (property == null) {
            return;
        }
        if (!property.isValid()) {
            throw new IllegalArgumentException("A property must be valid.");
        }
        Property property2 = new Property(property);
        this.properties_.add(property2);
    }

    public void addProperty(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        if (!property.isValid()) {
            throw new IllegalArgumentException("A property must be valid. property = " + property);
        }
        this.hashCode_ = 0;
        Property property2 = new Property(property);
        this.properties_.add(property2);
    }

    public Property removeProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        Property property = this.properties_.remove(sgfId);
        if (property != null) {
            this.hashCode_ = 0;
        }
        return property;
    }

    public void clearProperty() {
        this.properties_.clear();
        this.hashCode_ = 0;
    }

    public void setOpenUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.openUtr_ = string;
        this.hashCode_ = 0;
    }

    public void setCloseUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.closeUtr_ = string;
        this.hashCode_ = 0;
    }

    public boolean contains(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return this.properties_.contains(sgfId);
    }

    public Property getProperty(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.getProperty(SgfId.find(string));
    }

    public Property getProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        Property property = this.properties_.find(sgfId);
        if (property != null) {
            return new Property(property);
        }
        return null;
    }

    public Property[] getProperties() {
        Property[] propertyArray = new Property[this.properties_.size_];
        for (int i = 0; i < this.properties_.size_; ++i) {
            propertyArray[i] = new Property(this.properties_.properties_[i]);
        }
        return propertyArray;
    }

    public Set<SgfId> getPropertyIds() {
        HashSet<SgfId> hashSet = new HashSet<SgfId>(this.properties_.size_);
        for (int i = 0; i < this.properties_.size_; ++i) {
            hashSet.add(this.properties_.properties_[i].sgfId());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public boolean contains(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        return this.properties_.contains(propertyType);
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Node node = (Node)object;
        return this.properties_.equals(node.properties_) && this.openUtr_.equals(node.openUtr_) && this.closeUtr_.equals(node.closeUtr_);
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = this.properties_.hashCode() + this.openUtr_.hashCode() * 7 + this.closeUtr_.hashCode() * 11;
        }
        return this.hashCode_;
    }

    public String toString() {
        return this.properties_.toString();
    }

    private static class Properties {
        Property[] properties_;
        int size_;

        Properties() {
            this.size_ = 0;
            this.properties_ = new Property[1];
        }

        Properties(Properties properties) {
            this.properties_ = new Property[properties.size_];
            this.size_ = this.properties_.length;
            for (int i = 0; i < this.size_; ++i) {
                this.properties_[i] = new Property(properties.properties_[i]);
            }
        }

        boolean contains(SgfId sgfId) {
            return this.findIndex(sgfId) != -1;
        }

        boolean contains(PropertyType propertyType) {
            for (int i = 0; i < this.size_; ++i) {
                Property property = this.properties_[i];
                if (!property.sgfId().propertyType().equals(propertyType)) continue;
                return true;
            }
            return false;
        }

        void add(Property property) {
            int n = this.findIndex(property.sgfId());
            if (0 <= n) {
                this.properties_[n] = property;
                return;
            }
            if (this.properties_.length == this.size_) {
                this.expand();
            }
            if (property.sgfId().equals(SgfId.CHARSET)) {
                System.arraycopy(this.properties_, 0, this.properties_, 1, this.size_);
                this.properties_[0] = property;
            } else {
                this.properties_[this.size_] = property;
            }
            ++this.size_;
        }

        Property remove(SgfId sgfId) {
            int n = this.findIndex(sgfId);
            if (n == -1) {
                return null;
            }
            Property property = this.properties_[n];
            if (n + 1 != this.size_) {
                System.arraycopy(this.properties_, n + 1, this.properties_, n, this.size_ - n - 1);
            }
            --this.size_;
            return property;
        }

        Property find(SgfId sgfId) {
            int n = this.findIndex(sgfId);
            return n < 0 ? null : this.properties_[n];
        }

        int findIndex(SgfId sgfId) {
            for (int i = 0; i < this.size_; ++i) {
                Property property = this.properties_[i];
                if (!property.sgfId().equals(sgfId)) continue;
                return i;
            }
            return -1;
        }

        void clear() {
            this.size_ = 0;
        }

        private void expand() {
            Property[] propertyArray = this.properties_.length <= 1 ? new Property[5] : new Property[this.properties_.length * 2];
            System.arraycopy(this.properties_, 0, propertyArray, 0, this.size_);
            this.properties_ = propertyArray;
        }

        public int hashCode() {
            int n = 1;
            for (int i = 0; i < this.size_; ++i) {
                n += this.properties_[i].hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            Properties properties = (Properties)object;
            if (this.size_ != properties.size_) {
                return false;
            }
            for (int i = 0; i < this.size_; ++i) {
                if (this.properties_[i].equals(properties.properties_[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.size_; ++i) {
                stringBuilder.append(this.properties_[i].toString());
            }
            return stringBuilder.toString();
        }
    }
}

