/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.ForStackTraceException;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.Sequence;

public class GameTree {
    private static final Log log_s_ = LogFactory.getLog(GameTree.class);
    private GameTree parent_;
    private final Sequence sequence_;
    private final List<GameTree> gameTrees_;
    private String openUtr_;
    private String closeUtr_;
    private int hashCodePart_;

    public GameTree() {
        this.parent_ = null;
        this.sequence_ = new Sequence();
        this.gameTrees_ = new ArrayList<GameTree>(0);
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCodePart_ = 0;
    }

    public GameTree(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        this.parent_ = gameTree.parent_;
        this.sequence_ = new Sequence(gameTree.sequence_);
        this.gameTrees_ = new ArrayList<GameTree>(gameTree.gameTrees_.size());
        for (GameTree gameTree2 : gameTree.gameTrees_) {
            GameTree gameTree3 = new GameTree(gameTree2);
            gameTree3.parent_ = this;
            this.gameTrees_.add(gameTree3);
        }
        this.openUtr_ = gameTree.openUtr_;
        this.closeUtr_ = gameTree.closeUtr_;
        this.hashCodePart_ = gameTree.hashCodePart_;
    }

    public Sequence getSequence() {
        return this.sequence_;
    }

    public void addGameTree(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        if (this.contains(gameTree)) {
            throw new IllegalArgumentException();
        }
        if (gameTree.countNodes() == 0) {
            log_s_.log(LogLevel.INFO, new ForStackTraceException(), "No node argument never add as a child.");
            return;
        }
        if (gameTree.parent_ != null) {
            gameTree.parent_.gameTrees_.remove(gameTree);
        }
        this.gameTrees_.add(gameTree);
        gameTree.parent_ = this;
    }

    public boolean removeGameTree(GameTree gameTree) {
        if (this.gameTrees_.remove(gameTree)) {
            if (gameTree.parent_ == this) {
                gameTree.parent_ = null;
            }
            return true;
        }
        return false;
    }

    public void swapGameTree(int n, int n2) {
        Collections.swap(this.gameTrees_, n, n2);
    }

    public void clearGameTree() {
        for (GameTree gameTree : this.gameTrees_) {
            if (gameTree.parent_ != this) continue;
            gameTree.parent_ = null;
        }
        this.gameTrees_.clear();
    }

    public GameTree getParent() {
        return this.parent_;
    }

    public GameTree getChild(int n) {
        GameTree gameTree = this.gameTrees_.get(n);
        assert (gameTree.parent_ == this) : "Child does not have right parent(this). Child's parent is " + gameTree.parent_;
        return gameTree;
    }

    public GameTree[] getChildren() {
        GameTree[] gameTreeArray;
        for (GameTree gameTree : gameTreeArray = this.gameTrees_.toArray(new GameTree[this.gameTrees_.size()])) {
            assert (gameTree.parent_ == this) : "Child does not have right parent(this). Child's parent is " + gameTree.parent_;
        }
        return gameTreeArray;
    }

    public int getChildrenSize() {
        return this.gameTrees_.size();
    }

    public int countNodes() {
        int n = 0;
        Iterator<GameTree> iterator = this.gameTrees_.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().countNodes();
        }
        return n += this.sequence_.size();
    }

    public boolean contains(GameTree gameTree) {
        for (GameTree gameTree2 : this.gameTrees_) {
            if (gameTree2 != gameTree && !gameTree2.contains(gameTree)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDirectly(GameTree gameTree) {
        return this.gameTrees_.contains(gameTree);
    }

    public void setOpenUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.openUtr_ = string;
        this.hashCodePart_ = 0;
    }

    public void setCloseUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.closeUtr_ = string;
        this.hashCodePart_ = 0;
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        GameTree gameTree = (GameTree)object;
        return this.parent_ == gameTree.parent_ && this.sequence_.equals(gameTree.sequence_) && ((Object)this.gameTrees_).equals(gameTree.gameTrees_) && this.openUtr_.equals(gameTree.openUtr_) && this.closeUtr_.equals(gameTree.closeUtr_);
    }

    public int hashCode() {
        if (this.hashCodePart_ == 0) {
            this.hashCodePart_ = this.openUtr_.hashCode() * 11 + this.closeUtr_.hashCode() * 13;
        }
        return this.sequence_.hashCode() + this.gameTrees_.size() * 77 + this.hashCodePart_;
    }
}

