/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.linecodec;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unitarou.jface.linecodec.FontDataCodec;
import org.unitarou.jface.linecodec.RgbCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.linecodec.BooleanCodec;
import org.unitarou.linecodec.CharsetArrayCodec;
import org.unitarou.linecodec.EnumCodec;
import org.unitarou.linecodec.EnumSetCodec;
import org.unitarou.linecodec.FileArrayCodec;
import org.unitarou.linecodec.FileCodec;
import org.unitarou.linecodec.IntArrayCodec;
import org.unitarou.linecodec.IntegerCodec;
import org.unitarou.linecodec.LineCodec;
import org.unitarou.sgf.util.ProblemPropertyCodec;
import org.unitarou.util.ProviderCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineCodecServer {
    private static final Log log_s_ = LogFactory.getLog(LineCodecServer.class);
    private static final LineCodecServer instance_s_ = new LineCodecServer();
    private static final String OLD_CODEC_PACKAGE = "org.unitarou.jface.pref";
    private static final String[] NEW_CODEC_PACKAGES = new String[]{"org.unitarou.linecodec", "org.unitarou.jface.linecodec", "org.unitarou.sgf.util", "org.unitarou.util"};
    public static final char SEPARATOR = '@';
    private final Map<Class<? extends LineCodec>, LineCodec> codecMap_ = new LinkedHashMap<Class<? extends LineCodec>, LineCodec>();

    public static LineCodecServer instance() {
        return instance_s_;
    }

    private LineCodecServer() {
        this.codecMap_.put(BooleanCodec.class, new BooleanCodec());
        this.codecMap_.put(IntegerCodec.class, new IntegerCodec());
        this.codecMap_.put(IntArrayCodec.class, new IntArrayCodec());
        this.codecMap_.put(EnumCodec.class, new EnumCodec());
        this.codecMap_.put(ProviderCodec.class, new ProviderCodec());
        this.codecMap_.put(FileCodec.class, new FileCodec());
        this.codecMap_.put(FileArrayCodec.class, new FileArrayCodec());
        this.codecMap_.put(CharsetArrayCodec.class, new CharsetArrayCodec());
        this.codecMap_.put(RgbCodec.class, new RgbCodec());
        this.codecMap_.put(EnumSetCodec.class, new EnumSetCodec());
        this.codecMap_.put(ProblemPropertyCodec.class, new ProblemPropertyCodec());
        this.codecMap_.put(FontDataCodec.class, new FontDataCodec());
    }

    public boolean isEncodable(Object object) {
        for (LineCodec lineCodec : this.codecMap_.values()) {
            if (!lineCodec.isEncodable(object)) continue;
            return true;
        }
        return false;
    }

    public Object decode(Object object, String string) {
        ArgumentChecker.throwIfNull(object, (Object)string);
        for (LineCodec lineCodec : this.codecMap_.values()) {
            if (!lineCodec.isEncodable(object)) continue;
            return lineCodec.decode(string);
        }
        return null;
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.log(LogLevel.DEBUG, "[IGNORE] Unknown type value: {0}", string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        try {
            Class<?> clazz = this.getClass(string2);
            LineCodec lineCodec = this.codecMap_.get(clazz);
            if (lineCodec == null) {
                lineCodec = (LineCodec)clazz.newInstance();
            }
            return lineCodec.decode(string3);
        }
        catch (Exception exception) {
            log_s_.log(LogLevel.WARN, "[IGNORE] {0}@{1}", string, exception.getLocalizedMessage());
            return null;
        }
    }

    private Class<?> getClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!string.startsWith(OLD_CODEC_PACKAGE)) {
                throw classNotFoundException;
            }
            for (String string2 : NEW_CODEC_PACKAGES) {
                String string3 = string.replace(OLD_CODEC_PACKAGE, string2);
                try {
                    return Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw classNotFoundException;
        }
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        for (LineCodec lineCodec : this.codecMap_.values()) {
            if (!lineCodec.isEncodable(object)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(lineCodec.getClass().getName()).append('@').append(lineCodec.encode(object));
            return stringBuilder.toString();
        }
        return null;
    }

    public String encodeNoCodec(Object object) {
        ArgumentChecker.throwIfNull(object);
        for (LineCodec lineCodec : this.codecMap_.values()) {
            if (!lineCodec.isEncodable(object)) continue;
            String string = lineCodec.encode(object);
            if (lineCodec instanceof EnumCodec) {
                string = string.substring(string.indexOf(64) + 1);
            }
            return string;
        }
        return null;
    }
}

