/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.linecodec;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.linecodec.LineCodec;

public final class IntegerCodec
implements LineCodec {
    public boolean isEncodable(Object object) {
        return object instanceof Integer;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((Integer)object);
    }

    public String encode(Integer n) {
        ArgumentChecker.throwIfNull((Object)n);
        return n.toString();
    }

    public Integer decode(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

