/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.unitarou.lang.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceList<T>
implements Iterable<T> {
    private final Type type_;
    private final ReferenceQueue<T> referenceQueue_;
    private final LinkedList<Reference<T>> linkedList_;

    public ReferenceList() {
        this(Type.WEAK);
    }

    public ReferenceList(Type type) {
        ArgumentChecker.throwIfNull((Object)type);
        this.type_ = type;
        this.referenceQueue_ = new ReferenceQueue();
        this.linkedList_ = new LinkedList();
    }

    public boolean add(T t) {
        ArgumentChecker.throwIfNull(t);
        return this.linkedList_.add(this.createReference(t));
    }

    public void addAll(ReferenceList<T> referenceList) {
        ArgumentChecker.throwIfNull(referenceList);
        for (T t : referenceList) {
            this.linkedList_.add(this.createReference(t));
        }
    }

    private Reference<T> createReference(T t) {
        switch (this.type_) {
            case SOFT: {
                return new SoftReference<T>(t, this.referenceQueue_);
            }
            case WEAK: {
                return new WeakReference<T>(t, this.referenceQueue_);
            }
        }
        assert (false) : "Unknown type: " + this.type_.name();
        return null;
    }

    public boolean remove(T t) {
        boolean bl = false;
        Iterator iterator = this.linkedList_.iterator();
        while (iterator.hasNext()) {
            Object t2 = ((Reference)iterator.next()).get();
            if (t2 == null) {
                iterator.remove();
                continue;
            }
            if (!t2.equals(t)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public T[] toArray(T[] TArray) {
        ArgumentChecker.throwIfNull(TArray);
        List<T> list = this.getLiveInstances();
        return list.toArray(TArray);
    }

    private List<T> getLiveInstances() {
        ArrayList arrayList = new ArrayList(this.linkedList_.size());
        Iterator iterator = this.linkedList_.iterator();
        while (iterator.hasNext()) {
            Object t = ((Reference)iterator.next()).get();
            if (t == null) {
                iterator.remove();
                continue;
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<T> {
        private final List<T> array_;
        private int index_;

        private IteratorImpl() {
            this.array_ = ReferenceList.this.getLiveInstances();
            this.index_ = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index_ < this.array_.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.array_.get(this.index_++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WEAK,
        SOFT;

    }
}

