/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    public static Log getLog(Class<?> clazz) {
        return new LogImpl(LogManager.getLogger(clazz));
    }

    private static class LogImpl
    implements Log {
        private static final String FQCN = LogImpl.class.getName();
        private static final HashMap<LogLevel, Level> map_s_ = new HashMap();
        private final Logger logger_;

        private LogImpl(Logger logger) {
            this.logger_ = logger;
        }

        public boolean isEnabled(LogLevel logLevel) {
            if (logLevel == null) {
                return false;
            }
            return this.logger_.isEnabledFor(map_s_.get((Object)logLevel));
        }

        public void log(LogLevel logLevel, String string) {
            this.log(logLevel, null, string);
        }

        public void log(LogLevel logLevel, Throwable throwable, String string) {
            if (!this.isEnabled(logLevel)) {
                return;
            }
            this.logger_.log(FQCN, map_s_.get((Object)logLevel), string, throwable);
        }

        public void log(LogLevel logLevel, String string, Object ... objectArray) {
            this.log(logLevel, null, string, objectArray);
        }

        public void log(LogLevel logLevel, Throwable throwable, String string, Object ... objectArray) {
            if (!this.isEnabled(logLevel)) {
                return;
            }
            try {
                String string2 = MessageFormat.format(string, objectArray);
                this.log(logLevel, throwable, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger_.warn(MessageFormat.format("BAD ARGUMENTS, format={0}, args={1}", string, this.toString(objectArray)));
            }
        }

        private String toString(Object ... objectArray) {
            if (objectArray == null) {
                return "null";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (Object object : objectArray) {
                stringBuilder.append(object.toString()).append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        static {
            map_s_.put(LogLevel.FATAL, Level.FATAL);
            map_s_.put(LogLevel.ERROR, Level.ERROR);
            map_s_.put(LogLevel.WARN, Level.WARN);
            map_s_.put(LogLevel.INFO, Level.INFO);
            map_s_.put(LogLevel.DEBUG, Level.DEBUG);
            map_s_.put(LogLevel.TRACE, Level.TRACE);
        }
    }
}

