/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.util.Collection;
import org.unitarou.lang.Exceptions;
import org.unitarou.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentChecker {
    public static void throwIfNull(Object object) {
        if (object == null) {
            throw new NullArgumentException(new Object[]{null});
        }
    }

    public static void throwIfNull(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullArgumentException(object, object2);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3) {
        if (object == null || object2 == null || object3 == null) {
            throw new NullArgumentException(object, object2, object3);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            throw new NullArgumentException(object, object2, object3, object4);
        }
    }

    public static void throwIfNull(Object ... objectArray) {
        if (objectArray == null) {
            throw new NullArgumentException("Argument array must not be null.");
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullArgumentException(objectArray);
        }
    }

    public static void throwIfZeroOrLess(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(Exceptions.format("Argument must not be One or more. Parameter is {0}", l));
        }
    }

    public static void throwIfNegative(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Exceptions.format("Argument must not be minus value. Parameter is {0}", l));
        }
    }

    public static void throwIfOutOfBounds(long l, long l2, long l3) {
        if (l < l2 || l3 <= l) {
            throw new IllegalArgumentException(Exceptions.format("Argument is {0}. It must be between {1} and {2}(less than).", l, l2, l3));
        }
    }

    public static void throwIfOutOfBounds(int n, Collection<?> collection) {
        ArgumentChecker.throwIfNull(collection);
        if (n < 0 || collection.size() <= n) {
            throw new IllegalArgumentException();
        }
    }

    public static void throwIfDifferentLength(byte[][] byArray, byte[][] byArray2) {
        ArgumentChecker.throwIfNull(byArray, byArray2);
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException(Exceptions.format("Array size must be same, but: arg1.length={0}, arg2.length={1}", byArray.length, byArray2.length));
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i].length == byArray2[i].length) continue;
            throw new IllegalArgumentException(Exceptions.format("Array size must be same, but: arg1[{0}].length={1}, arg2[{0}].length={2}", i, byArray[i].length, byArray2[i].length));
        }
    }

    public static void throwIfFalse(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void throwIfFalse(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(Exceptions.format(string, objectArray));
        }
    }

    public static boolean isNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    protected ArgumentChecker() {
    }
}

