/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorResource
extends ImageResource {
    private static final Log log_s_ = LogFactory.getLog(CursorResource.class);
    private static final Map<String, Cursor> cursorMap_s_ = new TreeMap<String, Cursor>();
    private static final Runnable disposeExec_s_ = new Runnable(){

        public void run() {
            Iterator iterator = cursorMap_s_.values().iterator();
            while (iterator.hasNext()) {
                ((Cursor)iterator.next()).dispose();
            }
            cursorMap_s_.clear();
        }
    };
    private Cursor cursor_ = null;
    private final Point hotspot_;

    public CursorResource(Class<?> clazz, String string, Point point) {
        super(clazz, string);
        this.hotspot_ = point;
    }

    public Cursor getCursor() {
        if (this.cursor_ == null) {
            this.setup();
        } else if (this.cursor_.isDisposed()) {
            log_s_.log(LogLevel.WARN, "Cursor {0} has been disposed (SWT bug?)", this.getKey());
            this.setup();
        }
        return this.cursor_;
    }

    private void setup() {
        ImageData imageData = this.getImageData();
        if (imageData == null) {
            log_s_.log(LogLevel.WARN, "Can''t find image [{0}] use MissingImage.", this.getKey());
            imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        Display display = Display.getCurrent();
        this.cursor_ = new Cursor((Device)display, imageData, this.hotspot_.x, this.hotspot_.y);
        if (cursorMap_s_.isEmpty()) {
            display.disposeExec(disposeExec_s_);
        }
        cursorMap_s_.put(this.getKey(), this.cursor_);
    }
}

