/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.IntBuffer;
import org.apache.commons.io.FileUtils;
import org.unitarou.io.FileMappedIntArray;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.IntComparator;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.linecodec.TypedProperties;

public class IntSuffixArray
implements Closeable {
    private static final Log log_s_ = LogFactory.getLog(IntSuffixArray.class);
    public static final String PROPERTY_FILE_SUFFIX = ".properties";
    public static final String DATA_FILE_SUFFIX = ".data.isa";
    public static final String INDEX_FILE_SUFFIX = ".index.isa";
    private static final String KEY_LIMIT_LENGTH = "limitLength";
    private static final String KEY_IS_SORTED = "isSorted";
    private static final String KEY_DATA_ARRAY_SIZE = "dataArraySize";
    private static final String KEY_DATA_BLOCK_SIZE = "dataBlockSize";
    private static final String KEY_INDEX_ARRAY_SIZE = "indexArraySize";
    private static final String KEY_INDEX_BLOCK_SIZE = "indexBlockSize";
    private static final String PROPERTY_COMMENT = "This file is generated automatically by " + IntSuffixArray.class.getCanonicalName() + ". \n#You must not edit this manually.";
    private final File propertyFile_;
    private final FileMappedIntArray dataArray_;
    private final FileMappedIntArray indexArray_;
    private int limitLength_;
    private boolean isSorted_;

    public IntSuffixArray(File file, String string) throws IOException {
        this(file, string, Integer.MAX_VALUE, 0x100000, 256, 524288, 32768);
    }

    public IntSuffixArray(File file, String string, int n, int n2, int n3, int n4, int n5) throws IOException {
        ArgumentChecker.throwIfNull((Object)file, (Object)string);
        ArgumentChecker.throwIfFalse(Ios.isNormalDirectory(file), "File can not create. {0} is not a normal directory.", file);
        ArgumentChecker.throwIfZeroOrLess(n);
        ArgumentChecker.throwIfZeroOrLess(n2);
        ArgumentChecker.throwIfOutOfBounds(n3, 1L, n2 + 1);
        ArgumentChecker.throwIfZeroOrLess(n4);
        ArgumentChecker.throwIfOutOfBounds(n5, 1L, n4 + 1);
        File file2 = new File(file, string + DATA_FILE_SUFFIX);
        File file3 = new File(file, string + INDEX_FILE_SUFFIX);
        this.propertyFile_ = new File(file, string + PROPERTY_FILE_SUFFIX);
        TypedProperties typedProperties = this.loadProperties();
        this.limitLength_ = typedProperties.get(KEY_LIMIT_LENGTH, n);
        this.isSorted_ = typedProperties.get(KEY_IS_SORTED, Boolean.TRUE);
        n2 = typedProperties.get(KEY_DATA_ARRAY_SIZE, n2);
        n3 = typedProperties.get(KEY_DATA_BLOCK_SIZE, n3);
        n4 = typedProperties.get(KEY_INDEX_ARRAY_SIZE, n4);
        n5 = typedProperties.get(KEY_INDEX_BLOCK_SIZE, n5);
        this.dataArray_ = new FileMappedIntArray(file2, n3, n2 / n3);
        this.indexArray_ = new FileMappedIntArray(file3, n5, n4 / n5);
    }

    public void close() throws IOException {
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.set(KEY_LIMIT_LENGTH, this.limitLength_);
        typedProperties.set(KEY_IS_SORTED, this.isSorted_);
        typedProperties.set(KEY_DATA_ARRAY_SIZE, this.dataArray_.getWindowSize() * this.dataArray_.getNumOfWindows());
        typedProperties.set(KEY_DATA_BLOCK_SIZE, this.dataArray_.getWindowSize());
        typedProperties.set(KEY_INDEX_ARRAY_SIZE, this.indexArray_.getWindowSize() * this.indexArray_.getNumOfWindows());
        typedProperties.set(KEY_INDEX_BLOCK_SIZE, this.indexArray_.getWindowSize());
        this.saveProperties(typedProperties);
        Ios.closeQuietly(this.dataArray_, this.indexArray_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypedProperties loadProperties() throws IOException {
        TypedProperties typedProperties;
        FileInputStream fileInputStream = null;
        try {
            FileUtils.touch(this.propertyFile_);
            fileInputStream = new FileInputStream(this.propertyFile_);
            TypedProperties typedProperties2 = new TypedProperties();
            typedProperties2.load(fileInputStream);
            typedProperties = typedProperties2;
        }
        catch (Throwable throwable) {
            Ios.closeQuietly(fileInputStream);
            throw throwable;
        }
        Ios.closeQuietly((Closeable)fileInputStream);
        return typedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(TypedProperties typedProperties) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.propertyFile_);
            typedProperties.store(fileOutputStream, PROPERTY_COMMENT);
        }
        catch (Throwable throwable) {
            Ios.closeQuietly(fileOutputStream);
            throw throwable;
        }
        Ios.closeQuietly((Closeable)fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.dataArray_.isOpen()) {
                log_s_.log(LogLevel.WARN, "Client has not call close().");
                Ios.closeQuietly((Closeable)this);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        this.dataArray_.clear();
        this.indexArray_.clear();
    }

    public void add(int n) {
        if (!this.canAdd()) {
            throw new IllegalStateException("This array is full: " + this.dataArray_.size());
        }
        if (this.dataArray_.size() == this.indexArray_.size()) {
            this.indexArray_.add((int)this.indexArray_.size());
        }
        this.dataArray_.add(n);
        this.isSorted_ = false;
    }

    public void remove(int n, int n2) {
        this.dataArray_.remove(n, n2);
        this.isSorted_ = false;
    }

    public void set(int n, int n2) {
        this.dataArray_.set(n, n2);
        this.isSorted_ = false;
    }

    public int get(int n) {
        return this.dataArray_.get(n);
    }

    public int getSuffixIndex(int n) {
        ArgumentChecker.throwIfOutOfBounds(n, 0L, this.size());
        this.sortSuffixArray();
        return this.indexArray_.get(n);
    }

    public int size() {
        long l = this.dataArray_.size();
        if (Integer.MAX_VALUE < l) {
            throw new IllegalStateException();
        }
        return (int)l;
    }

    public int onMemorySize() {
        long l = this.dataArray_.onMemorySize() + this.indexArray_.onMemorySize();
        if (Integer.MAX_VALUE < l) {
            throw new IllegalStateException();
        }
        return (int)l;
    }

    public void flash() {
        this.dataArray_.flash();
        this.indexArray_.flash();
    }

    public int getLimitLength() {
        return this.limitLength_;
    }

    public void setLimitLength(int n) {
        ArgumentChecker.throwIfOutOfBounds(n, this.dataArray_.size() + 1L, Integer.MAX_VALUE);
        this.limitLength_ = n;
    }

    public boolean canAdd() {
        return this.dataArray_.size() < (long)this.limitLength_;
    }

    public boolean isSorted() {
        return this.isSorted_;
    }

    public void delete() throws IOException {
        this.close();
        this.deleteImpl(this.propertyFile_);
        this.deleteImpl(this.dataArray_.getMapFile());
        this.deleteImpl(this.indexArray_.getMapFile());
    }

    private void deleteImpl(File file) throws IOException {
        if (file.canWrite() && !file.delete()) {
            throw new IOException("Deleting failure " + file.getAbsolutePath());
        }
    }

    public int[] search(int ... nArray) {
        int n;
        int n2;
        ArgumentChecker.throwIfNull((Object)nArray);
        if (nArray.length == 0) {
            return new int[0];
        }
        this.sortSuffixArray();
        int n3 = 0;
        int n4 = (int)this.indexArray_.size() - 1;
        int n5 = -1;
        while (n3 <= n4) {
            n2 = n3 + n4 >>> 1;
            n = this.indexArray_.get(n2);
            int n6 = this.compare(n, nArray);
            if (n6 == 0) {
                n5 = n2;
                break;
            }
            if (n6 < 0) {
                n3 = n2 + 1;
                continue;
            }
            n4 = n2 - 1;
        }
        if (n5 == -1) {
            return new int[0];
        }
        n2 = n5;
        while (0 <= n2 - 1 && this.compare(this.indexArray_.get(n2 - 1), nArray) == 0) {
            --n2;
        }
        n = n5;
        while ((long)(n + 1) < this.indexArray_.size() && this.compare(this.indexArray_.get(n + 1), nArray) == 0) {
            ++n;
        }
        int[] nArray2 = new int[n - n2 + 1];
        for (int i = 0; i <= n - n2; ++i) {
            nArray2[i] = this.indexArray_.get(n2 + i);
        }
        return nArray2;
    }

    private int compare(int n, int[] nArray) {
        int n2 = n;
        int n3 = 0;
        do {
            int n4;
            int n5;
            if ((n5 = this.dataArray_.get(n2)) != (n4 = nArray[n3])) {
                return n5 < n4 ? -1 : 1;
            }
            if (++n3 != nArray.length) continue;
            return 0;
        } while ((long)(++n2) != this.dataArray_.size());
        return -1;
    }

    public boolean ensureSort() {
        boolean bl = this.isSorted_;
        this.sortSuffixArray();
        return bl;
    }

    private void sortSuffixArray() {
        int n;
        if (this.dataArray_.size() < this.indexArray_.size()) {
            this.indexArray_.remove(this.dataArray_.size(), this.indexArray_.size());
            n = 0;
            while ((long)n < this.indexArray_.size()) {
                this.indexArray_.set(n, n);
                ++n;
            }
            this.isSorted_ = false;
        }
        if (this.isSorted_) {
            return;
        }
        n = (int)this.dataArray_.size();
        final IntBuffer intBuffer = this.dataArray_.loadAllData();
        this.indexArray_.sort(new IntComparator(){

            public int compare(int n5, int n2) {
                if (n5 == n2) {
                    return 0;
                }
                do {
                    int n3;
                    int n4;
                    if ((n4 = intBuffer.get(n5)) != (n3 = intBuffer.get(n2))) {
                        return n4 < n3 ? -1 : 1;
                    }
                    ++n2;
                    if (++n5 != n) continue;
                    return -1;
                } while (n2 != n);
                return 1;
            }
        });
        this.isSorted_ = true;
    }
}

