/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    private static final HsqlTimer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabaseURIs() {
        Vector<String> vector = new Vector<String>();
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = (Database)iterator.next();
                vector.addElement(database.getURI());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int n) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = (Database)iterator.next();
                try {
                    database.close(n);
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Session newSession(int n, String string, String string2) throws HsqlException {
        Database database = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            database = (Database)databaseIDMap.get(n);
        }
        return database == null ? null : database.connect(string, string2);
    }

    public static Session newSession(String string, String string2, String string3, String string4, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        return database == null ? null : database.connect(string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Session getSession(int n, int n2) {
        Database database = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            database = (Database)databaseIDMap.get(n);
        }
        return database == null ? null : database.sessionManager.getSession(n2);
    }

    static int getDatabase(String string, String string2, Server server, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        DatabaseManager.registerServer(server, database);
        return database.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        Database database;
        Database database2 = database = DatabaseManager.getDatabaseObject(string, string2, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(string, string2) == null) {
                        DatabaseManager.addDatabaseObject(string, string2, database);
                    }
                    database.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Database getDatabaseObject(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        HashMap hashMap;
        String string3 = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (string == "res:") {
            hashMap = resDatabaseMap;
        } else if (string == "mem:") {
            hashMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.getDatabaseObject");
        }
        Database database = (Database)hashMap.get(string3);
        if (database == null) {
            database = new Database(string, string2, string3, hsqlProperties);
            database.databaseID = dbIDCounter;
            IntKeyHashMap intKeyHashMap = databaseIDMap;
            synchronized (intKeyHashMap) {
                databaseIDMap.put(dbIDCounter, database);
                ++dbIDCounter;
            }
            hashMap.put(string3, database);
        }
        return database;
    }

    private static synchronized Database lookupDatabaseObject(String string, String string2) throws HsqlException {
        HashMap hashMap;
        String string3 = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (string == "res:") {
            hashMap = resDatabaseMap;
        } else if (string == "mem:") {
            hashMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
        }
        return (Database)hashMap.get(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addDatabaseObject(String string, String string2, Database database) throws HsqlException {
        HashMap hashMap;
        String string3 = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (string == "res:") {
            hashMap = resDatabaseMap;
        } else if (string == "mem:") {
            hashMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.addDatabaseObject()");
        }
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            databaseIDMap.put(database.databaseID, database);
        }
        hashMap.put(string3, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDatabase(Database database) {
        BaseHashMap baseHashMap;
        HashMap hashMap;
        String string;
        int n = database.databaseID;
        String string2 = database.getType();
        String string3 = string = database.getPath();
        DatabaseManager.notifyServers(database);
        if (string2 == "file:") {
            hashMap = fileDatabaseMap;
            try {
                string3 = DatabaseManager.filePathToKey(string);
            }
            catch (HsqlException hsqlException) {
                baseHashMap = hashMap;
                synchronized (baseHashMap) {
                    Iterator iterator = hashMap.keySet().iterator();
                    Object object = null;
                    while (iterator.hasNext()) {
                        Object object2 = iterator.next();
                        if (hashMap.get(object2) != database) continue;
                        object = object2;
                        break;
                    }
                    if (object != null) {
                        string3 = object;
                    }
                }
            }
        } else if (string2 == "res:") {
            hashMap = resDatabaseMap;
        } else if (string2 == "mem:") {
            hashMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
        }
        boolean bl = false;
        baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(n);
            bl = databaseIDMap.isEmpty();
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            hashMap.remove(string3);
        }
        if (bl) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database database) {
        Iterator iterator = serverMap.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            hashSet.remove(database);
            if (!hashSet.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static void registerServer(Server server, Database database) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet hashSet = (HashSet)serverMap.get(server);
        hashSet.add(database);
    }

    private static void notifyServers(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            server.notify(0, database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String string) throws HsqlException {
        try {
            return FileUtil.getDefaultInstance().canonicalOrAbsolutePath(string);
        }
        catch (Exception exception) {
            throw Trace.error(29, exception.toString());
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

