/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    long mozillaHandle;
    long embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static long eventProc;
    static final int STOP_PROPOGATE = 1;
    static boolean IsSparc;

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }

    MozillaDelegate(Browser browser) {
        if (IsSparc) {
            byte[] byArray = Converter.wcsToMbcs(null, "libCrun.so.1", true);
            OS.dlopen(byArray, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
        this.browser = browser;
    }

    static long eventProc(long l, long l2, long l3) {
        long l4 = OS.gtk_widget_get_parent(l);
        if ((l4 = OS.gtk_widget_get_parent(l4)) == 0L) {
            return 0L;
        }
        Widget widget = Display.getCurrent().findWidget(l4);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(l, l2, l3);
        }
        return 0L;
    }

    static Browser findBrowser(long l) {
        long l2 = OS.gtk_widget_get_parent(l);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(l2);
    }

    static String getLibraryName() {
        return "libxpcom.so";
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return Converter.mbcsToWcs(string, byArray);
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        return Converter.wcsToMbcs(string, string2, bl);
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    long getHandle() {
        this.embedHandle = OS.gtk_hbox_new(false, 0);
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    String getJSLibraryName() {
        return "libmozjs.so";
    }

    String getProfilePath() {
        String string = System.getProperty("user.home");
        return String.valueOf(string) + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String GetSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    long gtk_event(long l, long l2, long l3) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        if (gdkEvent.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (l3 == 1L) {
            return 1L;
        }
        return 0L;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void handleMouseDown() {
        int n = this.browser.getShell().getStyle();
        if ((n & 0x4000) != 0 && ((n & 0x80000) == 0 || (this.browser.getStyle() & 0x80000) == 0)) {
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MozillaDelegate.this.browser == null || MozillaDelegate.this.browser.isDisposed()) {
                        return;
                    }
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Activate();
                }
            });
        }
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        long l;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0L) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((l = OS.gtk_container_get_children(this.embedHandle)) != 0L) {
            this.mozillaHandle = OS.g_list_data(l);
            OS.g_list_free(l);
            if (this.mozillaHandle != 0L) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1L);
            }
        }
    }

    boolean needsSpinup() {
        return true;
    }

    void onDispose(long l) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(long l, int n, int n2) {
        OS.gtk_widget_set_size_request(l, n, n2);
    }
}

