/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;

public class ImageList {
    int handle;
    int style;
    int refCount;
    Image[] images;

    public ImageList(int n) {
        this(n, 32, 32);
    }

    public ImageList(int n, int n2, int n3) {
        this.style = n;
        int n4 = 1;
        if (OS.IsWinCE) {
            n4 |= 0;
        } else if (OS.COMCTL32_MAJOR >= 6) {
            n4 |= 0x20;
        } else {
            int n5 = OS.GetDC(0);
            int n6 = OS.GetDeviceCaps(n5, 12);
            int n7 = OS.GetDeviceCaps(n5, 14);
            OS.ReleaseDC(0, n5);
            int n8 = n6 * n7;
            switch (n8) {
                case 4: {
                    n4 |= 4;
                    break;
                }
                case 8: {
                    n4 |= 8;
                    break;
                }
                case 16: {
                    n4 |= 0x10;
                    break;
                }
                case 24: {
                    n4 |= 0x18;
                    break;
                }
                case 32: {
                    n4 |= 0x20;
                    break;
                }
                default: {
                    n4 |= 0;
                }
            }
        }
        if ((n & 0x4000000) != 0) {
            n4 |= 0x2000;
        }
        this.handle = OS.ImageList_Create(n2, n3, n4, 16, 16);
        this.images = new Image[4];
    }

    public int add(Image image) {
        Image[] imageArray;
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null && this.images[n2].isDisposed()) {
                this.images[n2] = null;
            }
            if (this.images[n2] == null) break;
            ++n2;
        }
        if (n == 0) {
            imageArray = image.getBounds();
            OS.ImageList_SetIconSize(this.handle, imageArray.width, imageArray.height);
        }
        this.set(n2, image, n);
        if (n2 == this.images.length) {
            imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        return n2;
    }

    public int addRef() {
        return ++this.refCount;
    }

    int copyBitmap(int n, int n2, int n3) {
        int n4;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n, BITMAP.sizeof, bITMAP);
        int n5 = OS.GetDC(0);
        int n6 = OS.CreateCompatibleDC(n5);
        OS.SelectObject(n6, n);
        int n7 = OS.CreateCompatibleDC(n5);
        if (bITMAP.bmBitsPixel == 32 && OS.COMCTL32_MAJOR >= 6) {
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER.biWidth = n2;
            bITMAPINFOHEADER.biHeight = -n3;
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)24;
            bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
            byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
            OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
            if (OS.IsWinCE) {
                int n8 = 65280;
                int n9 = 0xFF0000;
                int n10 = -16777216;
                int n11 = BITMAPINFOHEADER.sizeof;
                byArray[n11] = (byte)((n8 & 0xFF000000) >> 24);
                byArray[n11 + 1] = (byte)((n8 & 0xFF0000) >> 16);
                byArray[n11 + 2] = (byte)((n8 & 0xFF00) >> 8);
                byArray[n11 + 3] = (byte)((n8 & 0xFF) >> 0);
                byArray[n11 + 4] = (byte)((n9 & 0xFF000000) >> 24);
                byArray[n11 + 5] = (byte)((n9 & 0xFF0000) >> 16);
                byArray[n11 + 6] = (byte)((n9 & 0xFF00) >> 8);
                byArray[n11 + 7] = (byte)((n9 & 0xFF) >> 0);
                byArray[n11 + 8] = (byte)((n10 & 0xFF000000) >> 24);
                byArray[n11 + 9] = (byte)((n10 & 0xFF0000) >> 16);
                byArray[n11 + 10] = (byte)((n10 & 0xFF00) >> 8);
                byArray[n11 + 11] = (byte)((n10 & 0xFF) >> 0);
            }
            int[] nArray = new int[1];
            n4 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
        } else {
            n4 = OS.CreateCompatibleBitmap(n5, n2, n3);
        }
        OS.SelectObject(n7, n4);
        if (n2 != bITMAP.bmWidth || n3 != bITMAP.bmHeight) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n7, 3);
            }
            OS.StretchBlt(n7, 0, 0, n2, n3, n6, 0, 0, bITMAP.bmWidth, bITMAP.bmHeight, 0xCC0020);
        } else {
            OS.BitBlt(n7, 0, 0, n2, n3, n6, 0, 0, 0xCC0020);
        }
        OS.DeleteDC(n6);
        OS.DeleteDC(n7);
        OS.ReleaseDC(0, n5);
        return n4;
    }

    int copyIcon(int n, int n2, int n3) {
        int n4;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (n4 = OS.CopyImage(n, 1, n2, n3, 0)) != 0 ? n4 : n;
    }

    int copyWithAlpha(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        byte by;
        byte by2;
        int n8;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n, BITMAP.sizeof, bITMAP);
        int n9 = bITMAP.bmWidth;
        int n10 = bITMAP.bmHeight;
        int n11 = OS.GetDC(0);
        int n12 = OS.CreateCompatibleDC(n11);
        int n13 = OS.SelectObject(n12, n);
        int n14 = OS.CreateCompatibleDC(n11);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n9;
        bITMAPINFOHEADER.biHeight = -n10;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray2 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray2, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n15 = OS.CreateDIBSection(0, byArray2, 0, nArray, 0, 0);
        if (n15 == 0) {
            SWT.error(2);
        }
        int n16 = OS.SelectObject(n14, n15);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(n15, BITMAP.sizeof, bITMAP2);
        int n17 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(n14, 0, 0, n9, n10, n12, 0, 0, 0xCC0020);
        byte[] byArray3 = new byte[n17];
        OS.MoveMemory(byArray3, bITMAP2.bmBits, n17);
        if (byArray != null) {
            n8 = bITMAP2.bmWidthBytes - n9 * 4;
            by2 = 0;
            by = 3;
            n7 = 0;
            while (n7 < n10) {
                n6 = 0;
                while (n6 < n9) {
                    byte by3 = by2;
                    by2 = (byte)(by2 + 1);
                    byArray3[by] = byArray[by3];
                    by += 4;
                    ++n6;
                }
                by += n8;
                ++n7;
            }
        } else {
            n8 = n2 & 0xFF;
            by2 = (byte)(n2 >> 8 & 0xFF);
            by = (byte)(n2 >> 16 & 0xFF);
            n7 = bITMAP2.bmWidthBytes - n9 * 4;
            n6 = 3;
            n5 = 0;
            while (n5 < n10) {
                int n18 = 0;
                while (n18 < n9) {
                    byArray3[n6] = byArray3[n6 - 1] == n8 && byArray3[n6 - 2] == by2 && byArray3[n6 - 3] == by ? 0 : -1;
                    n6 += 4;
                    ++n18;
                }
                n6 += n7;
                ++n5;
            }
        }
        OS.MoveMemory(bITMAP2.bmBits, byArray3, n17);
        if (n9 != n3 || n10 != n4) {
            BITMAPINFOHEADER bITMAPINFOHEADER2 = new BITMAPINFOHEADER();
            bITMAPINFOHEADER2.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER2.biWidth = n3;
            bITMAPINFOHEADER2.biHeight = -n4;
            bITMAPINFOHEADER2.biPlanes = 1;
            bITMAPINFOHEADER2.biBitCount = (short)32;
            bITMAPINFOHEADER2.biCompression = 0;
            byte[] byArray4 = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(byArray4, bITMAPINFOHEADER2, BITMAPINFOHEADER.sizeof);
            int[] nArray2 = new int[1];
            n7 = OS.CreateDIBSection(0, byArray4, 0, nArray2, 0, 0);
            n6 = OS.CreateCompatibleDC(n11);
            n5 = OS.SelectObject(n6, n7);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n6, 3);
            }
            OS.StretchBlt(n6, 0, 0, n3, n4, n14, 0, 0, n9, n10, 0xCC0020);
            OS.SelectObject(n6, n5);
            OS.DeleteDC(n6);
            OS.SelectObject(n14, n16);
            OS.DeleteDC(n14);
            OS.DeleteObject(n15);
            n15 = n7;
        } else {
            OS.SelectObject(n14, n16);
            OS.DeleteDC(n14);
        }
        OS.SelectObject(n12, n13);
        OS.DeleteDC(n12);
        OS.ReleaseDC(0, n11);
        return n15;
    }

    int createMaskFromAlpha(ImageData imageData, int n, int n2) {
        int n3;
        int n4 = imageData.width;
        int n5 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n4, n5, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n6 = 0;
        int n7 = 0;
        while (n7 < imageData2.height) {
            n3 = 0;
            while (n3 < imageData2.width) {
                imageData2.setPixel(n3, n7, (imageData.alphaData[n6++] & 0xFF) <= 127 ? 1 : 0);
                ++n3;
            }
            ++n7;
        }
        n7 = OS.CreateBitmap(n4, n5, 1, 1, imageData2.data);
        if (n4 != n || n5 != n2) {
            n3 = OS.GetDC(0);
            int n8 = OS.CreateCompatibleDC(n3);
            OS.SelectObject(n8, n7);
            int n9 = OS.CreateCompatibleDC(n3);
            int n10 = OS.CreateBitmap(n, n2, 1, 1, null);
            OS.SelectObject(n9, n10);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n9, 3);
            }
            OS.StretchBlt(n9, 0, 0, n, n2, n8, 0, 0, n4, n5, 0xCC0020);
            OS.DeleteDC(n8);
            OS.DeleteDC(n9);
            OS.ReleaseDC(0, n3);
            OS.DeleteObject(n7);
            n7 = n10;
        }
        return n7;
    }

    int createMask(int n, int n2, int n3, int n4, int n5) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n, BITMAP.sizeof, bITMAP);
        int n6 = bITMAP.bmWidth;
        int n7 = bITMAP.bmHeight;
        int n8 = OS.CreateBitmap(n2, n3, 1, 1, null);
        int n9 = OS.GetDC(0);
        int n10 = OS.CreateCompatibleDC(n9);
        if (n4 != -1) {
            int n11;
            OS.SelectObject(n10, n);
            boolean bl = bITMAP.bmBits != 0;
            byte[] byArray = null;
            if (!OS.IsWinCE && n5 != -1 && bl && bITMAP.bmBitsPixel <= 8) {
                n11 = 1 << bITMAP.bmBitsPixel;
                byte[] byArray2 = new byte[n11 * 4];
                OS.GetDIBColorTable(n10, 0, n11, byArray2);
                int n12 = n5 * 4;
                byte[] byArray3 = new byte[byArray2.length];
                byArray3[n12] = -1;
                byArray3[n12 + 1] = -1;
                byArray3[n12 + 2] = -1;
                OS.SetDIBColorTable(n10, 0, n11, byArray3);
                byArray = byArray2;
                OS.SetBkColor(n10, 0xFFFFFF);
            } else {
                OS.SetBkColor(n10, n4);
            }
            n11 = OS.CreateCompatibleDC(n9);
            OS.SelectObject(n11, n8);
            if (n2 != n6 || n3 != n7) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(n11, 3);
                }
                OS.StretchBlt(n11, 0, 0, n2, n3, n10, 0, 0, n6, n7, 0xCC0020);
            } else {
                OS.BitBlt(n11, 0, 0, n2, n3, n10, 0, 0, 0xCC0020);
            }
            OS.DeleteDC(n11);
            if (byArray != null) {
                OS.SetDIBColorTable(n10, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
        } else {
            int n13 = OS.SelectObject(n10, n8);
            OS.PatBlt(n10, 0, 0, n2, n3, 66);
            OS.SelectObject(n10, n13);
        }
        OS.ReleaseDC(0, n9);
        OS.DeleteDC(n10);
        return n8;
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0;
        this.images = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public int getStyle() {
        return this.style;
    }

    public int getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int indexOf(Image image) {
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null) {
                if (this.images[n2].isDisposed()) {
                    this.images[n2] = null;
                }
                if (this.images[n2] != null && this.images[n2].equals(image)) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public void put(int n, Image image) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image, n2);
        }
        this.images[n] = image;
    }

    public void remove(int n) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        OS.ImageList_Remove(this.handle, n);
        System.arraycopy(this.images, n + 1, this.images, n, --n2 - n);
        this.images[n] = null;
    }

    public int removeRef() {
        return --this.refCount;
    }

    void set(int n, Image image, int n2) {
        int n3 = image.handle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        switch (image.type) {
            case 0: {
                int n4 = 0;
                int n5 = 0;
                ImageData imageData = image.getImageData();
                switch (imageData.getTransparencyType()) {
                    case 1: {
                        if (OS.COMCTL32_MAJOR >= 6) {
                            n4 = this.copyWithAlpha(n3, -1, imageData.alphaData, nArray[0], nArray2[0]);
                            break;
                        }
                        n4 = this.copyBitmap(n3, nArray[0], nArray2[0]);
                        n5 = this.createMaskFromAlpha(imageData, nArray[0], nArray2[0]);
                        break;
                    }
                    case 4: {
                        int n6 = -1;
                        Color color = image.getBackground();
                        if (color != null) {
                            n6 = color.handle;
                        }
                        n4 = this.copyBitmap(n3, nArray[0], nArray2[0]);
                        n5 = this.createMask(n3, nArray[0], nArray2[0], n6, imageData.transparentPixel);
                        break;
                    }
                    default: {
                        n4 = this.copyBitmap(n3, nArray[0], nArray2[0]);
                        if (n == n2) break;
                        n5 = this.createMask(n3, nArray[0], nArray2[0], -1, -1);
                    }
                }
                if (n == n2) {
                    OS.ImageList_Add(this.handle, n4, n5);
                } else {
                    OS.ImageList_Replace(this.handle, n, n4, n5);
                }
                if (n5 != 0) {
                    OS.DeleteObject(n5);
                }
                if (n4 == n3) break;
                OS.DeleteObject(n4);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon(this.handle, n == n2 ? -1 : n, n3);
                    break;
                }
                int n7 = this.copyIcon(n3, nArray[0], nArray2[0]);
                OS.ImageList_ReplaceIcon(this.handle, n == n2 ? -1 : n, n7);
                OS.DestroyIcon(n7);
            }
        }
    }

    public int size() {
        int n = 0;
        int n2 = OS.ImageList_GetImageCount(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            if (this.images[n3] != null) {
                if (this.images[n3].isDisposed()) {
                    this.images[n3] = null;
                }
                if (this.images[n3] != null) {
                    ++n;
                }
            }
            ++n3;
        }
        return n;
    }
}

