/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.provider.rgtlp.DefaultRgtLabelProvider;

public class RgtComposer {
    private static final Message LB_VERSUS = new Message(DefaultRgtLabelProvider.class, "lbVersus");
    private static final Message LB_UNKNOWN = new Message(DefaultRgtLabelProvider.class, "lbUnknown");

    public static CharSequence composePlayerInfo(Sequence sequence) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SgfColor.BLACK.displayName()).append(':').append(RgtComposer.formatPlayer(sequence, SgfColor.BLACK)).append(' ').append(LB_VERSUS.get()).append(' ').append(SgfColor.WHITE.displayName()).append(':').append(RgtComposer.formatPlayer(sequence, SgfColor.WHITE));
        return stringBuilder;
    }

    public static CharSequence formatPlayer(Sequence sequence, SgfColor sgfColor) {
        SgfId sgfId;
        SgfId sgfId2;
        if (SgfColor.BLACK.equals(sgfColor)) {
            sgfId2 = SgfId.PLAYER_BLACK;
            sgfId = SgfId.BLACK_RANK;
        } else {
            sgfId2 = SgfId.PLAYER_WHITE;
            sgfId = SgfId.WHITE_RANK;
        }
        Node node = BasicFinder.findNode(sequence, sgfId2);
        if (node == null) {
            return "";
        }
        CharSequence charSequence = RgtComposer.compose(node, sgfId2, sgfId);
        if (charSequence.length() == 0) {
            return LB_UNKNOWN.get();
        }
        return charSequence;
    }

    public static CharSequence composeEventInfo(Sequence sequence) {
        Node node = BasicFinder.findNode(sequence, SgfId.EVENT);
        if (node != null) {
            return RgtComposer.compose(node, SgfId.EVENT, SgfId.ROUND);
        }
        return "";
    }

    public static CharSequence compose(Node node, SgfId sgfId, SgfId sgfId2) {
        String string = BasicFinder.findDatum(node, sgfId);
        String string2 = BasicFinder.findDatum(node, sgfId2);
        return RgtComposer.compose(string, string2);
    }

    public static CharSequence compose(CharSequence charSequence, CharSequence charSequence2) {
        if (Strings.isEmpty(charSequence)) {
            return "";
        }
        if (Strings.isEmpty(charSequence2)) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + charSequence2.length() + 2);
        stringBuilder.append(charSequence).append('[').append(charSequence2).append(']');
        return stringBuilder;
    }
}

