/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.provider.rgtlp.DefaultRgtLabelProvider;

public class GreedyRgtLabelProvider
extends DefaultRgtLabelProvider {
    private static final Message LB_GAME = new Message(GreedyRgtLabelProvider.class, "lbGame");
    private static final Message LB_PROBLEM = new Message(GreedyRgtLabelProvider.class, "lbProblem");
    private static final Message LB_DRILL = new Message(GreedyRgtLabelProvider.class, "lbDrill");

    public String displayName() {
        return super.displayName();
    }

    public String getLabel(RootGameTree rootGameTree) {
        String string = super.getLabel(rootGameTree);
        if (string.length() != 0) {
            return string;
        }
        switch (rootGameTree.getGameType()) {
            case GAME: {
                string = this.getLabelAsGame(rootGameTree);
                break;
            }
            case PROBLEM: {
                string = this.getLabelAsProblem(rootGameTree);
                break;
            }
            case DRILL: {
                string = this.getLabelAsDrill(rootGameTree);
                break;
            }
        }
        return string;
    }

    private String getLabelAsGame(RootGameTree rootGameTree) {
        return LB_GAME.get(rootGameTree.getSize(), this.makeHandicapLabel(rootGameTree), this.countMoves(rootGameTree));
    }

    private String makeHandicapLabel(RootGameTree rootGameTree) {
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.HANDICAP);
        if (string.length() == 0) {
            return "";
        }
        SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
        if (sgfNumber == null) {
            return "";
        }
        Handicap handicap = new Handicap(sgfNumber.getIntValue());
        return handicap.displayName();
    }

    private int countMoves(RootGameTree rootGameTree) {
        int n = 0;
        RootGameTree rootGameTree2 = rootGameTree;
        while (rootGameTree2 != null) {
            Sequence sequence = rootGameTree2.getSequence();
            for (Node node : sequence) {
                if (!node.contains(SgfId.BLACK) && !node.contains(SgfId.WHITE)) continue;
                ++n;
            }
            rootGameTree2 = rootGameTree2.getChildrenSize() == 0 ? null : rootGameTree2.getChild(0);
        }
        return n;
    }

    private String getLabelAsProblem(RootGameTree rootGameTree) {
        return LB_PROBLEM.get(this.makeResultLabel(rootGameTree), this.countMoves(rootGameTree));
    }

    private String makeResultLabel(RootGameTree rootGameTree) {
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.RESULT);
        if (string.length() == 0) {
            return "";
        }
        Result result = Result.parse(string);
        switch (result.getArchetype()) {
            case OTHER: {
                return result.getValue();
            }
            case BLACK_WIN: 
            case WHITE_WIN: {
                return result.getArchetype().displayName() + result.getScore();
            }
        }
        return result.getArchetype().displayName();
    }

    private String getLabelAsDrill(RootGameTree rootGameTree) {
        return LB_DRILL.get((Object)this.countProblems(rootGameTree));
    }

    private int countProblems(RootGameTree rootGameTree) {
        String[] stringArray = BasicFinder.findData(rootGameTree.getSequence(), SgfId.INPUT_FILES);
        if (stringArray == null) {
            return 0;
        }
        return stringArray.length;
    }
}

