/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.provider.abp;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import org.eclipse.swt.graphics.FontData;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.view.jface.provider.abp.AbstractAsciiBoardProvider;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardOption;

public class EnglishAsciiBoradProvider
extends AbstractAsciiBoardProvider {
    private static final Message LB_DISPLAY_NAME = new Message(EnglishAsciiBoradProvider.class, "lbDisplayName");
    private static final ContextValue<FontData> FONT_DATA = new ContextValue<FontData>(EnglishAsciiBoradProvider.class, "fontData", new FontData("Courier New", 10, 0));
    private static final ContextValue<EnumSet<AsciiBoardOption>> OPTIONS = new ContextValue<EnumSet<AsciiBoardOption>>(EnglishAsciiBoradProvider.class, "options", EnumSet.of(AsciiBoardOption.SHOW_COORDINATE, AsciiBoardOption.DECOLATE_EDGE));
    private final NumberFormat numberFormat_ = new DecimalFormat("00");

    public EnglishAsciiBoradProvider() {
        super(FONT_DATA, OPTIONS);
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    public boolean isSupported(AsciiBoardOption asciiBoardOption) {
        ArgumentChecker.throwIfNull((Object)asciiBoardOption);
        switch (asciiBoardOption) {
            case DECOLATE_EDGE: 
            case SHOW_COORDINATE: {
                return true;
            }
        }
        return false;
    }

    protected void appendStartCoordinalte(StringBuilder stringBuilder, int n, int n2) {
        if (this.getOptions().contains((Object)AsciiBoardOption.DECOLATE_EDGE)) {
            if (n == 1) {
                stringBuilder.append("   ");
            }
            this.appendCoordinate(stringBuilder, n, n2);
            stringBuilder.append(Strings.LINE_SEPARATOR);
            if (n == 1) {
                stringBuilder.append("  ");
            }
            this.appendEdge(stringBuilder, n, n2);
            stringBuilder.append(Strings.LINE_SEPARATOR);
        } else {
            if (n == 1) {
                stringBuilder.append("  ");
            }
            this.appendCoordinate(stringBuilder, n, n2);
            stringBuilder.append(Strings.LINE_SEPARATOR);
        }
    }

    protected void appendEndCoordinalte(StringBuilder stringBuilder, int n, int n2) {
        if (this.getOptions().contains((Object)AsciiBoardOption.DECOLATE_EDGE)) {
            if (n == 1) {
                stringBuilder.append("  ");
            }
            this.appendEdge(stringBuilder, n, n2);
            stringBuilder.append(Strings.LINE_SEPARATOR);
            if (n == 1) {
                stringBuilder.append("   ");
            }
            this.appendCoordinate(stringBuilder, n, n2);
        } else {
            if (n == 1) {
                stringBuilder.append("  ");
            }
            this.appendCoordinate(stringBuilder, n, n2);
        }
    }

    private void appendCoordinate(StringBuilder stringBuilder, int n, int n2) {
        for (int i = n - 1; i < Math.min(19, n2); ++i) {
            stringBuilder.append((char)(65 + i)).append(' ');
        }
    }

    private void appendEdge(StringBuilder stringBuilder, int n, int n2) {
        if (n == 1) {
            stringBuilder.append("+-");
        } else {
            stringBuilder.append("-");
        }
        for (int i = n + 1; i <= Math.min(18, n2 - 1); ++i) {
            stringBuilder.append("--");
        }
        if (n2 == 19) {
            stringBuilder.append("---+");
        } else {
            stringBuilder.append("--");
        }
    }

    protected void appendLeftCoordinalte(StringBuilder stringBuilder, int n) {
        if (this.getOptions().contains((Object)AsciiBoardOption.DECOLATE_EDGE)) {
            stringBuilder.append(this.numberFormat_.format(n)).append("|");
        } else {
            stringBuilder.append(this.numberFormat_.format(n));
        }
    }

    protected void appendRightCoordinalte(StringBuilder stringBuilder, int n) {
        if (this.getOptions().contains((Object)AsciiBoardOption.DECOLATE_EDGE)) {
            stringBuilder.append("|").append(this.numberFormat_.format(n));
        } else {
            stringBuilder.append(this.numberFormat_.format(n));
        }
    }

    protected CharSequence get(AbstractAsciiBoardProvider.PointType pointType) {
        switch (pointType) {
            case BLACK: 
            case L_BLACK: {
                return "# ";
            }
            case WHITE: 
            case L_WHITE: {
                return "O ";
            }
            case TOP_LEFT: 
            case E_TOP_LEFT: 
            case BOTTOM_LEFT: 
            case E_BOTTOM_LEFT: 
            case TOP: 
            case E_TOP: 
            case BOTTOM: 
            case E_BOTTOM: 
            case TOP_RIGHT: 
            case E_TOP_RIGHT: 
            case BOTTOM_RIGHT: 
            case E_BOTTOM_RIGHT: 
            case LEFT: 
            case E_LEFT: 
            case CENTER: 
            case STAR: 
            case RIGHT: 
            case E_RIGHT: {
                return ". ";
            }
        }
        return "  ";
    }
}

