/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.cmd.FocusInDrillEditorCommand;
import org.unitarou.yukinoshita.view.cmd.ShowDrillCommand;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.dr.IfContentProvider;
import org.unitarou.yukinoshita.view.jface.dr.IfElement;
import org.unitarou.yukinoshita.view.jface.dr.IfLabelProvider;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillEditorPanel
implements YukinoshitaPanel {
    private static final Log log_s_ = LogFactory.getLog(DrillEditorPanel.class);
    private static final Message CLB_EXPAND_ALL = new Message(DrillEditorPanel.class, "clbExpandAll");
    private static final Message CLB_COLLAPSE_ALL = new Message(DrillEditorPanel.class, "clbCollapseAll");
    private static final Message CLB_GROUP_OPTION = new Message(DrillEditorPanel.class, "clbGroupOption");
    private static final Message CLB_ADD = new Message(DrillEditorPanel.class, "clbAdd");
    private static final Message CLB_UP = new Message(DrillEditorPanel.class, "clbUp");
    private static final Message CLB_DOWN = new Message(DrillEditorPanel.class, "clbDown");
    private static final Message CLB_EDIT = new Message(DrillEditorPanel.class, "clbEdit");
    private static final Message CLB_REMOVE = new Message(DrillEditorPanel.class, "clbRemove");
    private static final Message NT_IGNORE_FILES = new Message(DrillEditorPanel.class, "ntIgnoreFiles");
    private static final Message MSG_IGNORE_FILES = new Message(DrillEditorPanel.class, "msgIgnoreFiles");
    private final Adapter adapter_ = new Adapter();
    private CollectionProxy collectionProxy_;
    private Property ifProperty_;
    private final SelectionListener cbSelectionListener_;
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Reference<NodeView> refNv_ = new WeakReference<Object>(null);
    private Composite frame_;
    private TreeViewer treeViewer_;
    private final Map<ProblemProperties.Flag, Button> cbPpMap_;
    private final Map<String, Button> btCommandMap_ = new HashMap<String, Button>();

    public DrillEditorPanel() {
        this.cbPpMap_ = new HashMap<ProblemProperties.Flag, Button>();
        this.cbSelectionListener_ = new SelectionListenerImpl();
    }

    @Override
    public void close() {
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new GridLayout(1, true));
        this.createProblemPropertyContents(this.frame_);
        this.createTreeHandlerContents(this.frame_);
        this.treeViewer_ = new TreeViewer(this.frame_, 2560);
        this.treeViewer_.getControl().setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer_.addPostSelectionChangedListener(this.adapter_);
        this.createControllerContents(this.frame_);
        this.treeViewer_.setContentProvider(new IfContentProvider());
        this.treeViewer_.setLabelProvider(new IfLabelProvider());
        this.currentChangedImpl();
        return this.frame_;
    }

    private void createProblemPropertyContents(Composite composite) {
        Group group = new Group(composite, 16);
        group.setText(CLB_GROUP_OPTION.get());
        group.setLayout(new FillLayout(512));
        EnumSet<ProblemProperties.Flag> enumSet = EnumSet.allOf(ProblemProperties.Flag.class);
        for (ProblemProperties.Flag flag : enumSet) {
            Button button = new Button(group, 32);
            button.setText(flag.getDisplayName());
            this.cbPpMap_.put(flag, button);
            button.addSelectionListener(this.cbSelectionListener_);
        }
    }

    private void createTreeHandlerContents(Composite composite) {
        Composite composite2 = new Composite(this.frame_, 0);
        composite2.setLayoutData(new GridData(4, 0x1000008, true, false));
        composite2.setLayout(new RowLayout(256));
        Button button = new Button(composite2, 8);
        button.setText(CLB_EXPAND_ALL.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.treeViewer_.expandAll();
            }
        });
        button = new Button(composite2, 8);
        button.setText(CLB_COLLAPSE_ALL.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.treeViewer_.collapseAll();
            }
        });
    }

    private void createControllerContents(Composite composite) {
        Composite composite2 = new Composite(this.frame_, 0);
        composite2.setLayoutData(new GridData(4, 0x1000008, true, false));
        composite2.setLayout(new RowLayout(256));
        Button button = new Button(composite2, 8);
        button.setText(CLB_ADD.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.addClick(selectionEvent);
            }
        });
        this.btCommandMap_.put("add", button);
        new Label(composite2, 0).setText(" ");
        button = new Button(composite2, 8);
        button.setText(CLB_UP.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.upClick(selectionEvent);
            }
        });
        this.btCommandMap_.put("up", button);
        button = new Button(composite2, 8);
        button.setText(CLB_DOWN.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.downClick(selectionEvent);
            }
        });
        this.btCommandMap_.put("down", button);
        button = new Button(composite2, 8);
        button.setText(CLB_EDIT.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.editClick(selectionEvent);
            }
        });
        this.btCommandMap_.put("edit", button);
        new Label(composite2, 0).setText(" ");
        button = new Button(composite2, 8);
        button.setText(CLB_REMOVE.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DrillEditorPanel.this.removeClick(selectionEvent);
            }
        });
        this.btCommandMap_.put("remove", button);
    }

    private void selectItem(SelectionChangedEvent selectionChangedEvent) {
        int n;
        this.btCommandMap_.get("edit").setEnabled((n = this.findSelectedIndex()) != -1);
        this.btCommandMap_.get("remove").setEnabled(n != -1);
        this.btCommandMap_.get("up").setEnabled(0 < n);
        this.btCommandMap_.get("down").setEnabled(0 <= n && n < this.ifProperty_.size() - 1);
        if (selectionChangedEvent.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IfElement) {
                this.eventBroker_.executeCommand(new FocusInDrillEditorCommand(((IfElement)object).getCollection()));
            } else if (object instanceof RootGameTree) {
                this.eventBroker_.executeCommand(new FocusInDrillEditorCommand((RootGameTree)object));
            }
        }
    }

    private void addClick(SelectionEvent selectionEvent) {
        Object object;
        int n = this.findSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        IgoFileDialog igoFileDialog = new IgoFileDialog(this.frame_.getShell(), IgoFileChooser.Style.OPEN_FILES);
        Collection collection = this.collectionProxy_.getCollection();
        igoFileDialog.setFolder(collection.getFile());
        igoFileDialog.open();
        File[] fileArray = igoFileDialog.getFiles();
        if (fileArray == null) {
            return;
        }
        String string = collection.getFile().getAbsolutePath();
        String string2 = FilenameUtils.getPrefix(string);
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file : fileArray) {
            File[] fileArray2 = file.getAbsolutePath();
            String string3 = FilenameUtils.getPrefix((String)fileArray2);
            if (string3.equals(string2)) {
                arrayList.add(file);
                continue;
            }
            arrayList2.add(file);
        }
        fileArray = arrayList.toArray(new File[arrayList.size()]);
        if (arrayList2.size() != 0) {
            object = new StringBuilder();
            for (File file : arrayList2) {
                ((StringBuilder)object).append(file.getAbsolutePath()).append(Strings.LINE_SEPARATOR);
            }
            ((StringBuilder)object).delete(((StringBuilder)object).length() - Strings.LINE_SEPARATOR.length(), ((StringBuilder)object).length());
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_IGNORE_FILES.get(), MSG_IGNORE_FILES.get((Object)((StringBuilder)object).toString()));
        }
        if (fileArray.length == 0) {
            return;
        }
        object = this.ifProperty_.getStrings();
        String[] stringArray = new String[((File[])object).length + fileArray.length];
        System.arraycopy(object, 0, stringArray, 0, n);
        File file = this.collectionProxy_.getCollection().getFile();
        int n2 = 0;
        for (File file2 : fileArray) {
            String string4 = Ios.calcRelativePath(file.getParent(), file2.getAbsolutePath());
            stringArray[n + n2] = FilenameUtils.separatorsToUnix(string4);
            ++n2;
        }
        for (int i = n + n2; i < stringArray.length; ++i) {
            stringArray[i] = object[i - n2];
        }
        this.updateIfProperty(stringArray);
    }

    private void upClick(SelectionEvent selectionEvent) {
        int n = this.findSelectedIndex();
        if (n < 1) {
            return;
        }
        String[] stringArray = this.ifProperty_.getStrings();
        String string = stringArray[n - 1];
        stringArray[n - 1] = stringArray[n];
        stringArray[n] = string;
        this.updateIfProperty(stringArray);
    }

    private void downClick(SelectionEvent selectionEvent) {
        int n = this.findSelectedIndex();
        String[] stringArray = this.ifProperty_.getStrings();
        if (n == -1 || stringArray.length - 1 <= n) {
            return;
        }
        String string = stringArray[n];
        stringArray[n] = stringArray[n + 1];
        stringArray[n + 1] = string;
        this.updateIfProperty(stringArray);
    }

    private void editClick(SelectionEvent selectionEvent) {
        String string;
        int n = this.findSelectedIndex();
        if (n == -1) {
            return;
        }
        File file = this.collectionProxy_.getCollection().getFile();
        IgoFileDialog igoFileDialog = new IgoFileDialog(this.frame_.getShell(), IgoFileChooser.Style.OPEN_FILE);
        String[] stringArray = this.ifProperty_.getStrings();
        String string2 = stringArray[n];
        igoFileDialog.setFolder(new File(file.getParent(), string2));
        if (!igoFileDialog.open()) {
            return;
        }
        String string3 = igoFileDialog.getFile().getAbsolutePath();
        stringArray[n] = string = Ios.calcRelativePath(file.getParent(), string3);
        this.updateIfProperty(stringArray);
    }

    private void removeClick(SelectionEvent selectionEvent) {
        int n = this.findSelectedIndex();
        if (n == -1) {
            return;
        }
        String[] stringArray = this.ifProperty_.getStrings();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        for (int i = n; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        Property property = new Property(SgfId.INPUT_FILES, stringArray[n]);
        this.ifProperty_.clear();
        this.ifProperty_.setId(SgfId.INPUT_FILES.id());
        for (String string : stringArray2) {
            this.ifProperty_.addValue(new Value(string));
        }
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[]{property}, this.ifProperty_, null));
    }

    private int findSelectedIndex() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer_.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IfElement)) {
            return -1;
        }
        String string = FilenameUtils.separatorsToUnix(((IfElement)object).getInputFileName());
        String[] stringArray = this.ifProperty_.getStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void updateIfProperty(String[] stringArray) {
        this.ifProperty_.clear();
        this.ifProperty_.setId(SgfId.INPUT_FILES.id());
        for (String string : stringArray) {
            this.ifProperty_.addValue(new Value(string));
        }
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[0], this.ifProperty_, null));
    }

    private void updatePpProperty() {
        int n = 0;
        for (Map.Entry<ProblemProperties.Flag, Button> entry : this.cbPpMap_.entrySet()) {
            if (entry.getValue().getSelection()) {
                n |= entry.getKey().getValue();
                continue;
            }
            n &= ~entry.getKey().getValue();
        }
        Property property = new Property(SgfId.PROBLEM_PROPERTIES, Integer.toString(n));
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[0], property, null));
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private void updateTreeViewer() {
        if (this.frame_ == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer_.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        String string = "";
        if (object instanceof IfElement) {
            string = ((IfElement)object).getInputFileName();
        }
        File file = this.collectionProxy_.getCollection().getFile();
        IfElement ifElement = null;
        String[] stringArray = this.ifProperty_.getStrings();
        IfElement[] ifElementArray = new IfElement[stringArray.length];
        for (int i = 0; i < ifElementArray.length; ++i) {
            ifElementArray[i] = new IfElement(file.getParent(), FilenameUtils.separatorsToSystem(stringArray[i]));
            if (!ifElementArray[i].getInputFileName().equals(string)) continue;
            ifElement = ifElementArray[i];
        }
        this.treeViewer_.setInput(ifElementArray);
        if (ifElement != null) {
            this.treeViewer_.setSelection(new StructuredSelection(ifElement));
        }
        Collection[] collectionArray = new Collection[ifElementArray.length];
        for (int i = 0; i < collectionArray.length; ++i) {
            collectionArray[i] = ifElementArray[i].getCollection();
        }
        log_s_.log(LogLevel.TRACE, "{0} seconds for getCollection.", stopWatch.lapSecond());
        this.eventBroker_.executeCommand(new ShowDrillCommand(collectionArray));
        log_s_.log(LogLevel.TRACE, "{0} seconds for execute ShowDrillCommand.", stopWatch.stopSecond());
    }

    private void currentChangedImpl() {
        NodeView nodeView = this.refNv_.get();
        if (nodeView == null) {
            return;
        }
        this.refNv_ = new WeakReference<NodeView>(nodeView);
        if (!GameType.DRILL.equals(nodeView.getRootView().getGameType())) {
            return;
        }
        this.ifProperty_ = nodeView.getProperty(SgfId.INPUT_FILES);
        if (this.ifProperty_ == null) {
            this.ifProperty_ = new Property();
            this.ifProperty_.setId(SgfId.INPUT_FILES.id());
        }
        this.updateTreeViewer();
        int n = 0;
        Property property = nodeView.getProperty(SgfId.PROBLEM_PROPERTIES);
        if (property != null) {
            String string = property.getString();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Map.Entry entry : this.cbPpMap_.entrySet()) {
            ((Button)entry.getValue()).setSelection(0 != (((ProblemProperties.Flag)((Object)entry.getKey())).getValue() & n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements EventBrokerMonitor,
    CollectionMonitor,
    NodeMonitor,
    OutlineMonitor,
    ISelectionChangedListener {
        private Adapter() {
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            DrillEditorPanel.this.eventBroker_.removeView(DrillEditorPanel.this);
            DrillEditorPanel.this.eventBroker_ = eventBroker;
            DrillEditorPanel.this.eventBroker_.addView(DrillEditorPanel.this);
        }

        @Override
        public void update(CollectionProxy collectionProxy) {
            ArgumentChecker.throwIfNull((Object)collectionProxy);
            DrillEditorPanel.this.collectionProxy_ = collectionProxy;
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            DrillEditorPanel.this.refNv_ = new WeakReference<NodeView>(nodeView);
            DrillEditorPanel.this.currentChangedImpl();
        }

        @Override
        public void show(Collection[] collectionArray) {
        }

        @Override
        public void setFocus(Collection collection) {
            IfElement[] ifElementArray;
            for (IfElement ifElement : ifElementArray = (IfElement[])DrillEditorPanel.this.treeViewer_.getInput()) {
                if (!ifElement.getCollection().equals(collection)) continue;
                DrillEditorPanel.this.treeViewer_.removePostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(ifElement));
                DrillEditorPanel.this.treeViewer_.addPostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                return;
            }
        }

        @Override
        public void setFocus(RootGameTree rootGameTree) {
            IfElement[] ifElementArray;
            for (IfElement ifElement : ifElementArray = (IfElement[])DrillEditorPanel.this.treeViewer_.getInput()) {
                Collection collection = ifElement.getCollection();
                for (int i = 0; i < collection.size(); ++i) {
                    if (!collection.get(i).equals(rootGameTree)) continue;
                    DrillEditorPanel.this.treeViewer_.removePostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                    DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(ifElement));
                    DrillEditorPanel.this.treeViewer_.expandToLevel(rootGameTree, -1);
                    DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(rootGameTree));
                    DrillEditorPanel.this.treeViewer_.addPostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                    return;
                }
            }
        }

        @Override
        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            DrillEditorPanel.this.selectItem(selectionChangedEvent);
        }
    }

    private class SelectionListenerImpl
    extends SelectionAdapter {
        private SelectionListenerImpl() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            DrillEditorPanel.this.updatePpProperty();
        }
    }
}

