/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg.fe;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SetStone;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class FeGameSetupEventDelegator
implements EventDelegator {
    private SgfColor currentColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.currentColor_ = SgfColor.BLACK;
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: 
            case 262144: {
                this.currentColor_ = this.currentColor_.opposite();
            }
        }
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, EventBroker eventBroker, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)eventBroker);
        BlockSituation blockSituation = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            return blockSituation;
        }
        if (blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) {
            if (SgfColor.BLACK.equals(this.currentColor_)) {
                blockSituation.setCursor(CanvasCursor.SET_BLACK.getCursor());
                blockSituation.setTransientProperty(SgfId.ADD_BLACK.makeProperty(blockStatus.getPoint()));
            } else {
                blockSituation.setCursor(CanvasCursor.SET_WHITE.getCursor());
                blockSituation.setTransientProperty(SgfId.ADD_WHITE.makeProperty(blockStatus.getPoint()));
            }
        }
        if (blockStatus.getPointTypes().contains((Object)SgfPointType.BLACK)) {
            blockSituation.setCursor(CanvasCursor.SET_BLACK_ERASE.getCursor());
            blockSituation.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
        }
        if (blockStatus.getPointTypes().contains((Object)SgfPointType.WHITE)) {
            blockSituation.setCursor(CanvasCursor.SET_WHITE_ERASE.getCursor());
            blockSituation.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
        }
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (mouseEvent.button == 3) {
            if (!blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) {
                SetStone setStone = new SetStone(null, blockStatus.getPoint());
                eventBroker.executeCommand(setStone);
                return true;
            }
            return false;
        }
        if (mouseEvent.button != 1) {
            return false;
        }
        SgfColor sgfColor = null;
        if (blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) {
            sgfColor = this.currentColor_;
            this.currentColor_ = this.currentColor_.opposite();
        }
        SetStone setStone = new SetStone(sgfColor, blockStatus.getPoint());
        eventBroker.executeCommand(setStone);
        if (sgfColor != null) {
            Property property = SgfId.DIM_POINTS.makeProperty(blockStatus.getPoint());
            UpdateProperty updateProperty = new UpdateProperty(new Property[]{property}, null, null);
            eventBroker.executeCommand(updateProperty);
        }
        return true;
    }
}

