/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.List;
import java.util.Map;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.view.jface.db.AbstractFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.DefaultTermSheet;
import org.unitarou.yukinoshita.view.jface.db.PlayerTermSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TermSheet
extends AbstractFilterPanel {
    static void createUnique(List<ColumnType> list, Map<ColumnType, TermSheet> map) {
        ArgumentChecker.throwIfNull(list, map);
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("termSheetMap must be empty.");
        }
        DefaultTermSheet defaultTermSheet = null;
        PlayerTermSheet playerTermSheet = null;
        for (ColumnType columnType : list) {
            if (ColumnType.PLAYER.equals((Object)columnType)) {
                if (playerTermSheet == null) {
                    playerTermSheet = new PlayerTermSheet();
                }
                map.put(columnType, playerTermSheet);
                continue;
            }
            if (defaultTermSheet == null) {
                defaultTermSheet = new DefaultTermSheet();
            }
            map.put(columnType, defaultTermSheet);
        }
    }

    TermSheet() {
    }

    protected abstract List<Term> getSelected();

    abstract void updateContents(GameType var1, ColumnType var2);
}

