/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.unitarou.ml.BasicMessages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.TermSheet;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlayerTermSheet
extends TermSheet {
    private Composite frame_;
    private Text txPattern_;
    private final UTable<Player> utPlayer_ = new UTable<Player>(new TableProvider(), 65538);
    private final List<Player> players_ = new ArrayList<Player>();

    @Override
    public void close() {
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(SwtFactory.createThinInnerGrid(1, true));
        Control control = this.createTermPatternFilterPart(this.frame_);
        control.setLayoutData(new GridData(4, 128, true, false));
        Table table = this.utPlayer_.createContents(this.frame_);
        table.setLinesVisible(true);
        table.setLayoutData(new GridData(4, 4, true, true));
        this.utPlayer_.getControl().addSelectionListener(new ListenerImpl());
        return this.frame_;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private Control createTermPatternFilterPart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createThinInnerGrid(2, false));
        Label label = new Label(composite2, 16384);
        label.setText(BasicMessages.LB_FILTER.get());
        label.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.txPattern_ = new Text(composite2, 2048);
        this.txPattern_.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.txPattern_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PlayerTermSheet.this.filter();
            }
        });
        return composite2;
    }

    private void filter() {
        String string = this.txPattern_.getText();
        if (string.length() == 0) {
            this.utPlayer_.clear();
            this.utPlayer_.addAll(this.players_);
            return;
        }
        ArrayList<Player> arrayList = new ArrayList<Player>(this.players_.size());
        for (Player player : this.players_) {
            if (player.name_.indexOf(string) == -1) continue;
            arrayList.add(player);
        }
        this.utPlayer_.clear();
        this.utPlayer_.addAll(arrayList);
    }

    @Override
    protected List<Term> getSelected() {
        List<Player> list = this.utPlayer_.getRecords();
        Table table = this.utPlayer_.getControl();
        ArrayList<Term> arrayList = new ArrayList<Term>(table.getSelectionCount());
        for (TableItem tableItem : table.getSelection()) {
            Term term;
            int n = table.indexOf(tableItem);
            Player player = list.get(n);
            if (player.blackCount_ != 0) {
                term = new Term();
                term.setSgfId(SgfId.PLAYER_BLACK.id());
                term.setGameType(GameType.GAME.getIntValue());
                term.setTermId(player.blackTermId_);
                term.setTerm(player.name_);
                arrayList.add(term);
            }
            if (player.whiteCount_ == 0) continue;
            term = new Term();
            term.setSgfId(SgfId.PLAYER_WHITE.id());
            term.setGameType(GameType.GAME.getIntValue());
            term.setTermId(player.whiteTermId_);
            term.setTerm(player.name_);
            arrayList.add(term);
        }
        return arrayList;
    }

    @Override
    void updateContents(GameType gameType, ColumnType columnType) {
        Player player;
        if (!ColumnType.PLAYER.equals((Object)columnType)) {
            throw new IllegalArgumentException();
        }
        List<TermFrequency> list = DatabaseManager.instance().searchTermFrequency(SgfId.PLAYER_BLACK, gameType);
        List<TermFrequency> list2 = DatabaseManager.instance().searchTermFrequency(SgfId.PLAYER_WHITE, gameType);
        HashMap<String, Player> hashMap = new HashMap<String, Player>();
        for (TermFrequency termFrequency : list) {
            player = new Player(termFrequency.getTerm());
            player.blackCount_ = termFrequency.getFrequency();
            player.blackTermId_ = termFrequency.getTermId();
            hashMap.put(player.name_, player);
        }
        for (TermFrequency termFrequency : list2) {
            player = (Player)hashMap.get(termFrequency.getTerm());
            if (player == null) {
                player = new Player(termFrequency.getTerm());
                hashMap.put(player.name_, player);
            }
            player.whiteCount_ = termFrequency.getFrequency();
            player.whiteTermId_ = termFrequency.getTermId();
        }
        this.players_.clear();
        this.players_.addAll(hashMap.values());
        Collections.sort(this.players_, new Comparator<Player>(){

            @Override
            public int compare(Player player, Player player2) {
                return player2.blackCount_ + player2.whiteCount_ - (player.blackCount_ + player.whiteCount_);
            }
        });
        this.players_.add(0, new Player(""));
        this.utPlayer_.clear();
        this.utPlayer_.addAll(this.players_);
        this.utPlayer_.packColumns();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableProvider
    implements UTableProvider<Player> {
        private TableProvider() {
        }

        @Override
        public int getColumnSize() {
            return 3;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[]{true, true, true};
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setText(ColumnType.PLAYER.toString());
            tableColumnArray[0].setMoveable(false);
            tableColumnArray[1].setText(SgfColor.BLACK.displayName());
            tableColumnArray[1].setMoveable(false);
            tableColumnArray[2].setText(SgfColor.WHITE.displayName());
            tableColumnArray[2].setMoveable(false);
        }

        @Override
        public void set(TableItem tableItem, Player player) {
            tableItem.setText(0, player.name_.length() == 0 ? BasicMessages.LB_NO_CHOICE.get() : player.name_);
            tableItem.setText(1, Integer.toString(player.blackCount_));
            tableItem.setText(2, Integer.toString(player.whiteCount_));
            int n = tableItem.getParent().indexOf(tableItem);
            tableItem.setBackground(SwtFactory.getZebraColor(n));
        }

        @Override
        public int compareTo(Player player, Player player2, int n) {
            switch (n) {
                case 0: {
                    return player.name_.compareTo(player2.name_);
                }
                case 1: {
                    return player.blackCount_ - player2.blackCount_;
                }
                case 2: {
                    return player.whiteCount_ - player2.whiteCount_;
                }
            }
            return 0;
        }
    }

    private static class Player {
        private int blackCount_;
        private int blackTermId_;
        private int whiteCount_;
        private int whiteTermId_;
        private final String name_;

        private Player(String string) {
            this.name_ = string;
        }
    }

    private class ListenerImpl
    extends SelectionAdapter {
        private ListenerImpl() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            for (FilterPanel.Listener listener : PlayerTermSheet.this.getListeners()) {
                listener.filterChanged();
            }
        }
    }
}

