/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.SetOperator;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermOperatorTree;
import org.unitarou.yukinoshita.view.jface.db.AbstractFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.BoardFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.Dataset;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.FingerprintQuery;
import org.unitarou.yukinoshita.view.jface.db.GameTableProvider;
import org.unitarou.yukinoshita.view.jface.db.GameThumbnailProvider;
import org.unitarou.yukinoshita.view.jface.db.SearchedFilePanel;
import org.unitarou.yukinoshita.view.jface.db.TermFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.TiSearchedFile;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameTypeDataset
implements Dataset {
    private final GameType gameType_;
    private final GameTypeFilterPanel filterPanel_;
    private final GameTableProvider tableProvider_;
    private final GameThumbnailProvider thumbnailProvider_;
    private final SearchedFilePanel searchedFilePanel_;

    public GameTypeDataset(GameType gameType) {
        ArgumentChecker.throwIfNull((Object)gameType);
        this.gameType_ = gameType;
        if (gameType.equals(GameType.GAME)) {
            this.filterPanel_ = new GameTypeFilterPanel(this.gameType_, Arrays.asList(ColumnType.PLAYER, ColumnType.SGF_RESULT, ColumnType.SGF_EVENT, ColumnType.SGF_ROUND, ColumnType.SGF_HANDICAP, ColumnType.SGF_KOMI, ColumnType.SGF_RULE, ColumnType.SGF_PLACE, ColumnType.SGF_TIMELIMIT));
            this.tableProvider_ = new GameTableProvider(gameType, Arrays.asList(ColumnType.SGF_PLAYER_BLACK, ColumnType.SGF_PLAYER_WHITE, ColumnType.SGF_HANDICAP, ColumnType.SGF_KOMI, ColumnType.SGF_EVENT, ColumnType.DATE, ColumnType.MOVES, ColumnType.SGF_RESULT, ColumnType.PATH, ColumnType.FILE_INDEX));
        } else if (gameType.equals(GameType.PROBLEM)) {
            this.filterPanel_ = new GameTypeFilterPanel(this.gameType_, Arrays.asList(ColumnType.SGF_GAME_NAME, ColumnType.SGF_TIMELIMIT, ColumnType.SGF_BLACK_RANK, ColumnType.SGF_RESULT));
            this.tableProvider_ = new GameTableProvider(gameType, Arrays.asList(ColumnType.SGF_TIMELIMIT, ColumnType.SGF_BLACK_RANK, ColumnType.MOVES, ColumnType.SGF_RESULT, ColumnType.PATH, ColumnType.FILE_INDEX));
        } else {
            throw new IllegalArgumentException();
        }
        this.filterPanel_.addListener(new Listener());
        this.thumbnailProvider_ = new GameThumbnailProvider();
        this.searchedFilePanel_ = new SearchedFilePanel(this.tableProvider_, this.thumbnailProvider_);
    }

    @Override
    public String displayName() {
        return this.gameType_.displayName();
    }

    @Override
    public FilterPanel getFilterPanel() {
        return this.filterPanel_;
    }

    @Override
    public WidgetContainer getSearchResultPanel() {
        return this.searchedFilePanel_;
    }

    @Override
    public void setViewStyle(Dataset.ViewStyle viewStyle) {
        ArgumentChecker.throwIfNull((Object)viewStyle);
        switch (viewStyle) {
            case TABLE: {
                this.filterPanel_.form_.setOrientation(256);
                break;
            }
            case THUMBNAIL: {
                this.filterPanel_.form_.setOrientation(512);
            }
        }
        this.searchedFilePanel_.changeStyle(viewStyle);
    }

    @Override
    public List<TiSearchedFile> getDataset() {
        SearchFileCondition searchFileCondition = new SearchFileCondition();
        searchFileCondition.setTarget(EnumSet.of(this.gameType_));
        searchFileCondition.setTermOperatorTree(this.filterPanel_.createTree());
        FingerprintQuery fingerprintQuery = this.filterPanel_.boardFilterPanel_.getFingerprintQuery();
        searchFileCondition.setFingerprintQuery(fingerprintQuery);
        searchFileCondition.setMoveQuery(this.filterPanel_.boardFilterPanel_.getMoveQuery());
        this.thumbnailProvider_.setFingerprintCondition(searchFileCondition);
        List<SearchedFile> list = DatabaseManager.instance().search(searchFileCondition);
        ArrayList<TiSearchedFile> arrayList = new ArrayList<TiSearchedFile>(list.size());
        for (SearchedFile searchedFile : list) {
            TiSearchedFile tiSearchedFile = new TiSearchedFile();
            tiSearchedFile.set(searchedFile);
            arrayList.add(tiSearchedFile);
        }
        return arrayList;
    }

    @Override
    public List<TiSearchedFile> getSelected() {
        return this.searchedFilePanel_.getSelected();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GameTypeFilterPanel
    extends AbstractFilterPanel {
        private final BoardFilterPanel boardFilterPanel_;
        private final List<TermFilterPanel> filterPanels_;
        private USashForm form_;

        public GameTypeFilterPanel(GameType gameType, List<ColumnType> list) {
            this.boardFilterPanel_ = new BoardFilterPanel(gameType);
            this.filterPanels_ = new ArrayList<TermFilterPanel>();
            this.filterPanels_.add(new TermFilterPanel(gameType, list, EnumSet.noneOf(SetOperator.class)));
            this.filterPanels_.add(new TermFilterPanel(gameType, list, EnumSet.noneOf(SetOperator.class)));
            ListenerImpl listenerImpl = new ListenerImpl();
            this.boardFilterPanel_.addListener(listenerImpl);
            for (TermFilterPanel termFilterPanel : this.filterPanels_) {
                termFilterPanel.addListener(listenerImpl);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public Control createContents(Composite composite) {
            this.form_ = SwtFactory.createUSashForm(composite, 256);
            int[] nArray = new int[this.filterPanels_.size() + 1];
            this.boardFilterPanel_.createContents(this.form_);
            nArray[0] = 1;
            for (int i = 0; i < this.filterPanels_.size(); ++i) {
                this.filterPanels_.get(i).createContents(this.form_);
                nArray[i + 1] = 1;
            }
            this.form_.setWeights(nArray);
            return this.form_;
        }

        @Override
        public USashForm getControl() {
            return this.form_;
        }

        public TermOperatorTree createTree() {
            TermOperatorTree termOperatorTree = new TermOperatorTree();
            termOperatorTree.setOperator(SetOperator.INTERSECT);
            for (TermFilterPanel termFilterPanel : ((GameTypeDataset)GameTypeDataset.this).filterPanel_.filterPanels_) {
                TermOperatorTree termOperatorTree2 = new TermOperatorTree();
                for (Term term : termFilterPanel.getSelected()) {
                    TermOperatorTree termOperatorTree3 = new TermOperatorTree(term);
                    termOperatorTree3.setOperator(SetOperator.UNION);
                    termOperatorTree2.addChild(termOperatorTree3);
                }
                if (!termOperatorTree2.isValid()) continue;
                if (termFilterPanel.getOperator() != null) {
                    termOperatorTree2.setOperator(termFilterPanel.getOperator());
                }
                termOperatorTree.addChild(termOperatorTree2);
            }
            return termOperatorTree;
        }

        private class ListenerImpl
        implements FilterPanel.Listener {
            private ListenerImpl() {
            }

            public void filterChanged() {
                for (FilterPanel.Listener listener : GameTypeFilterPanel.this.getListeners()) {
                    listener.filterChanged();
                }
            }
        }
    }

    private class Listener
    implements FilterPanel.Listener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filterChanged() {
            Shell shell = GameTypeDataset.this.searchedFilePanel_.getControl().getShell();
            try {
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                GameTypeDataset.this.searchedFilePanel_.notifyStartSearch();
                StopWatch stopWatch = new StopWatch();
                List<TiSearchedFile> list = GameTypeDataset.this.getDataset();
                GameTypeDataset.this.searchedFilePanel_.setDataset(list, stopWatch.stop());
            }
            finally {
                shell.setCursor(null);
            }
        }
    }
}

