/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprint;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Filter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.DimPointsPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FingerprintFilterIgoBoard
implements WidgetContainer {
    private final BoardPainter boardPainter_;
    private final RuledLinePainter ruledLinePainter_;
    private final StonePainter stonePainter_;
    private final DimPointsPainter dimPointsPainter_;
    private Canvas canvas_;
    private Image boardImage_;
    private RootGameTree rgt_;
    private GameType gameType_;

    public FingerprintFilterIgoBoard(GameType gameType) {
        ArgumentChecker.throwIfNull((Object)gameType);
        this.boardPainter_ = new SimpleBoardPainter();
        this.ruledLinePainter_ = new SimpleRuledLinePainter();
        this.stonePainter_ = StonePainter.CONTEXT.defaultValue();
        this.dimPointsPainter_ = new DimPointsPainter();
        this.canvas_ = null;
        this.boardImage_ = null;
        this.rgt_ = RootGameTreeFactory.createGame(SgfSize.DEFAULT, new Handicap(0));
        this.rgt_.setGameType(gameType);
        this.rgt_.getRootNode().addProperty(SgfId.DIM_POINTS.makeProperty(this.rgt_.getSize().all()));
        this.gameType_ = GameType.GAME;
    }

    @Override
    public Canvas createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (FingerprintFilterIgoBoard.this.boardImage_ == null) {
                    FingerprintFilterIgoBoard.this.drawImage();
                }
                paintEvent.gc.drawImage(FingerprintFilterIgoBoard.this.boardImage_, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Swts.disposeQuietly(FingerprintFilterIgoBoard.this.boardImage_);
                FingerprintFilterIgoBoard.this.boardImage_ = null;
            }
        });
        return this.canvas_;
    }

    @Override
    public Canvas getControl() {
        return this.canvas_;
    }

    @Override
    public void close() {
        Swts.disposeQuietly(this.boardImage_);
    }

    public void updateImage(GameType gameType, SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)gameType, (Object)sgfSize);
        this.gameType_ = gameType;
        this.rgt_.setSize(sgfSize);
        if (this.canvas_ == null) {
            return;
        }
        Swts.disposeQuietly(this.boardImage_);
        this.boardImage_ = null;
        this.canvas_.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage() {
        GC gC = null;
        try {
            this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
            gC = new GC(this.boardImage_);
            this.drawImageImpl(gC);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
    }

    private Rectangle getBoardSize() {
        if (this.canvas_ == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        Rectangle rectangle = this.canvas_.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return new Rectangle(0, 0, 100, 100);
        }
        return rectangle;
    }

    private void drawImageImpl(GC gC) {
        Fingerprint fingerprint = Fingerprints.calcFingerprint(this.rgt_);
        SgfPoint[] sgfPointArray = this.getDimArea();
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(sgfPointArray.length);
        Filter<SgfPoint> filter = fingerprint.getFilter();
        for (SgfPoint n : sgfPointArray) {
            hashSet.add(filter.filter(n));
        }
        SgfSize sgfSize = this.rgt_.getSize();
        SgfRectangle sgfRectangle = this.calcViewArea(sgfSize, fingerprint);
        Rectangle rectangle = this.boardImage_.getBounds();
        int n = Math.min(rectangle.width / sgfRectangle.width(), rectangle.height / sgfRectangle.height());
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        gC.fillRectangle(rectangle);
        if (n < 3) {
            return;
        }
        Point point = new Point((rectangle.width - n * sgfRectangle.width()) / 2, (rectangle.height - n * sgfRectangle.height()) / 2);
        SgfPoint sgfPoint = sgfRectangle.getStart();
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        for (int i = sgfPoint.y(); i <= sgfRectangle.getEnd().y(); ++i) {
            for (int j = sgfPoint.x(); j <= sgfRectangle.getEnd().x(); ++j) {
                SgfPoint sgfPoint2 = SgfPoint.create(sgfSize, j, i);
                Rectangle rectangle2 = new Rectangle((j - 1) * n + point.x, (i - 1) * n + point.y, n, n);
                this.boardPainter_.paint(gC, sgfPoint2, rectangle2);
                this.ruledLinePainter_.paint(gC, sgfPoint2, rectangle2);
                SgfColor sgfColor = fingerprint.getColor(j, i);
                if (sgfColor != null) {
                    Stone stone = new Stone(sgfColor, sgfPoint2, null);
                    this.setParameters(stonePainterParameter, stone);
                    this.stonePainter_.paintStone(gC, rectangle2, stonePainterParameter);
                }
                if (!hashSet.contains(sgfPoint2)) continue;
                this.dimPointsPainter_.paint(gC, rectangle2, false);
            }
        }
    }

    private SgfPoint[] getDimArea() {
        Property property = this.rgt_.getRootNode().getProperty(SgfId.DIM_POINTS);
        if (property == null) {
            return new SgfPoint[0];
        }
        String[] stringArray = property.getStrings();
        return SgfPoint.parse(this.rgt_.getSize(), stringArray);
    }

    private SgfRectangle calcViewArea(SgfSize sgfSize, Fingerprint fingerprint) {
        int n;
        int n2;
        int n3;
        SgfRectangle sgfRectangle = new SgfRectangle();
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        if (!GameType.PROBLEM.equals(this.gameType_)) {
            return sgfRectangle;
        }
        int n4 = n3 = sgfSize.width();
        while (n4 >= 2) {
            n2 = 0;
            for (n = 1; n <= sgfSize.height(); ++n) {
                if (null == fingerprint.getColor(n4, n)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
            n3 = n4--;
        }
        n2 = n4 = sgfSize.height();
        while (n2 >= 2) {
            n = 0;
            for (int i = 1; i <= sgfSize.width(); ++i) {
                if (null == fingerprint.getColor(i, n2)) continue;
                n = 1;
                break;
            }
            if (n != 0) break;
            n4 = n2--;
        }
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, n3, n4));
        return sgfRectangle;
    }

    private void setParameters(StonePainterParameter stonePainterParameter, Stone stone) {
        stonePainterParameter.setSgfColor(stone.getColor());
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(false);
    }

    public SgfSize getSize() {
        return this.rgt_.getSize();
    }

    public Set<SgfPoint> getFilter() {
        SgfPoint[] sgfPointArray = this.getDimArea();
        return new HashSet<SgfPoint>(Arrays.asList(sgfPointArray));
    }

    public void setFilter(List<SgfPoint> list) {
        ArgumentChecker.throwIfNull(list);
        Property property = this.rgt_.getRootNode().getProperty(SgfId.DIM_POINTS);
        if (property == null) {
            property = new Property(SgfId.DIM_POINTS, "");
        } else {
            property.clearValue();
        }
        for (SgfPoint sgfPoint : list) {
            property.addValue(new Value(sgfPoint.getString()));
        }
        this.rgt_.getRootNode().addProperty(property);
    }

    public void setGame(RootGameTree rootGameTree) {
        this.rgt_ = new RootGameTree(rootGameTree);
        this.boardImage_ = null;
        this.canvas_.redraw();
    }

    public RootGameTree getGame() {
        return new RootGameTree(this.rgt_);
    }
}

