/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.ol;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.jface.board.DigestIgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.ol.Alignment;
import org.unitarou.yukinoshita.view.jface.board.ol.IgoOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.ol.IgoOutlinePanelFactory;
import org.unitarou.yukinoshita.view.provider.rgtlp.OutlineRgtLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOutlinePanel
implements IgoOutlinePanel {
    private static final Log log_s_ = LogFactory.getLog(BasicOutlinePanel.class);
    private static final Message FMT_ANNOTATION = new Message(BasicOutlinePanel.class, "fmtAnnotation");
    private Composite frame_;
    private Alignment alignment_ = Alignment.BOTTOM;
    private Label annotationLabel_;
    private final DigestIgoBoardPanel digestIgoBoardPanel_ = new DigestIgoBoardPanel(false, false);
    private Control boardControl_;
    private RootGameTree rootGameTree_;
    private boolean isFocused_ = false;

    public static IgoOutlinePanelFactory<BasicOutlinePanel> factory() {
        return new FactoryImpl();
    }

    public final void setAlignment(Alignment alignment) {
        ArgumentChecker.throwIfNull((Object)alignment);
        if (this.frame_ != null) {
            log_s_.log(LogLevel.WARN, "Widgit has already created(BUG).");
            return;
        }
        this.alignment_ = alignment;
    }

    public final Alignment getAlignment() {
        return this.alignment_;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        switch (this.alignment_) {
            case TOP: {
                GridLayout gridLayout = new GridLayout(1, true);
                gridLayout.marginWidth = 2;
                gridLayout.marginHeight = 2;
                this.frame_.setLayout(gridLayout);
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData(new GridData(0x1000000, 1024, true, true));
                this.boardControl_ = this.digestIgoBoardPanel_.createContents(this.frame_);
                this.boardControl_.setLayoutData(new GridData(0x1000000, 128, true, true));
                break;
            }
            case BOTTOM: {
                GridLayout gridLayout = new GridLayout(1, true);
                gridLayout.marginWidth = 2;
                gridLayout.marginHeight = 2;
                this.frame_.setLayout(gridLayout);
                this.boardControl_ = this.digestIgoBoardPanel_.createContents(this.frame_);
                this.boardControl_.setLayoutData(new GridData(0x1000000, 4, true, false));
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData(new GridData(0x1000000, 128, true, true));
                break;
            }
            case LEFT: {
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginWidth = 2;
                gridLayout.marginHeight = 2;
                this.frame_.setLayout(gridLayout);
                this.boardControl_ = this.digestIgoBoardPanel_.createContents(this.frame_);
                this.boardControl_.setLayoutData(new GridData(131072, 0x1000000, true, true));
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData(new GridData(131072, 128, true, true));
                break;
            }
            case RIGHT: {
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginWidth = 2;
                gridLayout.marginHeight = 2;
                this.frame_.setLayout(gridLayout);
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData(new GridData(16384, 128, true, true));
                this.boardControl_ = this.digestIgoBoardPanel_.createContents(this.frame_);
                this.boardControl_.setLayoutData(new GridData(16384, 0x1000000, true, true));
                break;
            }
            default: {
                assert (false) : "Unknown alignment type :" + (Object)((Object)this.alignment_);
                break;
            }
        }
        return this.frame_;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public Control getBoardControl() {
        return this.boardControl_;
    }

    @Override
    public void close() {
    }

    @Override
    public void setRootGameTree(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.rootGameTree_ == rootGameTree) {
            return;
        }
        this.rootGameTree_ = rootGameTree;
        Result result = Result.parse(BasicFinder.findDatum(this.rootGameTree_.getSequence(), SgfId.RESULT));
        this.annotationLabel_.setText(FMT_ANNOTATION.get(rootGameTree.getGameType().displayName(), result.displayName(), new OutlineRgtLabelProvider().getLabel(this.rootGameTree_)));
        this.digestIgoBoardPanel_.updateImage(this.rootGameTree_);
    }

    @Override
    public void setSizeHint(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        GridData gridData = (GridData)this.frame_.getLayoutData();
        gridData.widthHint = point.x;
        int n = ((GridLayout)this.frame_.getLayout()).marginWidth;
        gridData = (GridData)this.boardControl_.getLayoutData();
        gridData.widthHint = point.x - this.frame_.getBorderWidth() * 2 - n * 2;
        gridData.heightHint = point.y - this.frame_.getBorderWidth() * 2 - n * 2;
        gridData = (GridData)this.annotationLabel_.getLayoutData();
        gridData.widthHint = point.x - this.frame_.getBorderWidth() * 2 - n * 2;
    }

    @Override
    public RootGameTree getRootGameTree() {
        return this.rootGameTree_;
    }

    @Override
    public boolean isFocused() {
        return this.isFocused_;
    }

    @Override
    public void setFocus(boolean bl) {
        this.isFocused_ = bl;
        Display display = this.frame_.getDisplay();
        this.frame_.setBackground(display.getSystemColor(bl ? 26 : 22));
        this.annotationLabel_.setBackground(display.getSystemColor(bl ? 26 : 22));
        this.annotationLabel_.setForeground(display.getSystemColor(bl ? 27 : 21));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryImpl
    implements IgoOutlinePanelFactory<BasicOutlinePanel> {
        private FactoryImpl() {
        }

        @Override
        public BasicOutlinePanel create() {
            return new BasicOutlinePanel();
        }
    }
}

