/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.mp.Painter;

public class DimPointsPainter
implements Painter {
    private static ColorRegistry colorRegistry_s_;
    public static final String CKEY_DIM;
    private static int alpha_s_;
    private ImageData dimData_ = null;
    private ImageData transientDimData_ = null;
    private Point boxSize_ = new Point(0, 0);

    public static int getAlpha() {
        return alpha_s_;
    }

    public static void setAlpha(int n) {
        alpha_s_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GC gC, Rectangle rectangle, boolean bl) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle);
        Point point = Geometry.getSize(rectangle);
        if (!this.boxSize_.equals(point)) {
            this.boxSize_ = point;
            this.create();
        }
        Image image = null;
        try {
            image = bl ? new Image(null, this.transientDimData_) : new Image(null, this.dimData_);
            gC.drawImage(image, rectangle.x, rectangle.y);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create() {
        Image image = null;
        GC gC = null;
        try {
            image = new Image(null, this.boxSize_.x, this.boxSize_.y);
            gC = new GC(image);
            gC.setBackground(colorRegistry_s_.get(CKEY_DIM));
            gC.fillRectangle(image.getBounds());
            this.dimData_ = image.getImageData();
            this.dimData_.alpha = alpha_s_;
            this.transientDimData_ = image.getImageData();
            this.transientDimData_.alpha = alpha_s_ / 2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
        Swts.disposeQuietly(image);
    }

    static {
        CKEY_DIM = Classes.uniqueKey(DimPointsPainter.class, "CKEY_DIM");
        alpha_s_ = 128;
        colorRegistry_s_ = JFaceResources.getColorRegistry();
        colorRegistry_s_.put(CKEY_DIM, new RGB(102, 51, 0));
    }
}

