/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.CursorResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SimpleText;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class MarkupEventDelegator
implements EventDelegator {
    private static final Messages msg_s_ = Messages.createByPackage(MarkupEventDelegator.class);
    private static final String NT_REQUEST_LABEL_TEXT = Messages.createKey(MarkupEventDelegator.class, "ntRequestLabelText");
    private static final String MSG_REQUEST_LABEL_TEXT = Messages.createKey(MarkupEventDelegator.class, "msgRequestLabelText");
    private static final CursorResource[] decorationCursors_s_;
    private static final SgfId[] markTypes_s_;
    private int currentMarkIndex_ = 0;

    public void resetStatus() {
        this.currentMarkIndex_ = 0;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, EventBroker eventBroker, MouseEvent mouseEvent) {
        String string;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)eventBroker);
        BlockSituation blockSituation = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            if (markTypes_s_[this.currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
                blockSituation.setCursor(CanvasCursor.MARK_DIMMED_ERASE.getCursor());
                blockSituation.setTransientProperty(SgfId.DIM_POINTS.makeProperty(SgfPoint.createPass(nodeView.getSize())));
            }
            return blockSituation;
        }
        SgfId sgfId = markTypes_s_[this.currentMarkIndex_];
        blockSituation.setCursor(decorationCursors_s_[this.currentMarkIndex_].getCursor());
        if (sgfId.valueType().equals((Object)ValueType.POINT)) {
            blockSituation.setTransientProperty(sgfId.makeProperty(blockStatus.getPoint()));
        } else if (sgfId.equals(SgfId.LABEL) && (string = this.getLabel(nodeView, blockStatus.getPoint())).length() != 0) {
            blockSituation.setTransientProperty(SgfId.LABEL.makeProperty(new Label(blockStatus.getPoint(), new SimpleText(string))));
        }
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            if (markTypes_s_[this.currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
                Property property = SgfId.DIM_POINTS.makeProperty(SgfPoint.createPass(nodeView.getSize()));
                eventBroker.executeCommand(new UpdateProperty(new Property[0], property, null));
                return true;
            }
            return false;
        }
        SgfPoint sgfPoint = blockStatus.getPoint();
        if (mouseEvent.button == 1) {
            Property[] propertyArray;
            Property property;
            SgfId sgfId = markTypes_s_[this.currentMarkIndex_];
            boolean bl = false;
            if (!SgfId.LABEL.equals(sgfId)) {
                property = new Property(sgfId, sgfPoint.getString());
            } else {
                propertyArray = this.askLabelText(nodeView, sgfPoint);
                if (propertyArray == null) {
                    return false;
                }
                if (propertyArray.equals("")) {
                    property = null;
                    bl = true;
                } else {
                    Label label = new Label(sgfPoint, new SimpleText((String)propertyArray));
                    property = new Property(sgfId, label.getString());
                }
            }
            propertyArray = this.composeRemoveMark(nodeView, sgfPoint, !bl);
            eventBroker.executeCommand(new UpdateProperty(propertyArray, property, null));
            return true;
        }
        if (mouseEvent.button == 3) {
            Property[] propertyArray = this.composeRemoveMark(nodeView, sgfPoint, false);
            eventBroker.executeCommand(new UpdateProperty(propertyArray, null, null));
            return true;
        }
        return false;
    }

    private String askLabelText(NodeView nodeView, SgfPoint sgfPoint) {
        String string = this.getLabel(nodeView, sgfPoint);
        InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), msg_s_.get(NT_REQUEST_LABEL_TEXT), msg_s_.get(MSG_REQUEST_LABEL_TEXT), string, null);
        if (inputDialog.open() == 0) {
            return inputDialog.getValue();
        }
        return null;
    }

    private String getLabel(NodeView nodeView, SgfPoint sgfPoint) {
        Property property = nodeView.getProperty(SgfId.LABEL);
        if (property == null) {
            return "";
        }
        String[] stringArray = property.getStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            Label label = Label.parseQuietly(sgfPoint.size(), stringArray[i]);
            if (label == null || !label.getPoint().equals(sgfPoint)) continue;
            return label.getLabel().getText();
        }
        return "";
    }

    private Property[] composeRemoveMark(NodeView nodeView, SgfPoint sgfPoint, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>(markTypes_s_.length);
        for (int i = 0; i < markTypes_s_.length; ++i) {
            if (bl && i == this.currentMarkIndex_) continue;
            if (SgfId.LABEL.equals(markTypes_s_[i])) {
                Label label = new Label(sgfPoint, new SimpleText(this.getLabel(nodeView, sgfPoint)));
                arrayList.add(markTypes_s_[i].makeProperty(label));
                continue;
            }
            arrayList.add(markTypes_s_[i].makeProperty(sgfPoint));
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: {
                --this.currentMarkIndex_;
                if (this.currentMarkIndex_ >= 0) break;
                this.currentMarkIndex_ = decorationCursors_s_.length - 1;
                break;
            }
            case 262144: {
                ++this.currentMarkIndex_;
                this.currentMarkIndex_ %= decorationCursors_s_.length;
            }
        }
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    static {
        ArrayList<CursorResource> arrayList = new ArrayList<CursorResource>(9);
        arrayList.add(CanvasCursor.MARK_CROSS);
        arrayList.add(CanvasCursor.MARK_CIRCLE);
        arrayList.add(CanvasCursor.MARK_SQUARE);
        arrayList.add(CanvasCursor.MARK_TRIANGLE);
        arrayList.add(CanvasCursor.MARK_SELECT);
        arrayList.add(CanvasCursor.MARK_LABEL);
        arrayList.add(CanvasCursor.MARK_TERRITORY_WHITE);
        arrayList.add(CanvasCursor.MARK_TERRITORY_BLACK);
        arrayList.add(CanvasCursor.MARK_DIMMED);
        decorationCursors_s_ = arrayList.toArray(new CursorResource[arrayList.size()]);
        ArrayList<SgfId> arrayList2 = new ArrayList<SgfId>(9);
        arrayList2.add(SgfId.MARK_WITH_X);
        arrayList2.add(SgfId.CIRCLE);
        arrayList2.add(SgfId.SQUARE);
        arrayList2.add(SgfId.TRIANGLE);
        arrayList2.add(SgfId.SELECTED);
        arrayList2.add(SgfId.LABEL);
        arrayList2.add(SgfId.TERRITORY_WHITE);
        arrayList2.add(SgfId.TERRITORY_BLACK);
        arrayList2.add(SgfId.DIM_POINTS);
        markTypes_s_ = arrayList2.toArray(new SgfId[arrayList.size()]);
    }
}

