/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.yukinoshita.model.board.PrintingIgoBoard;

class DigestIgoBoardLayout {
    private boolean isLandscape_;
    private SgfPoint boardStart_;
    private int blockSize_;
    private Point boardOffset_;
    private boolean showPiled_;
    private int piledBlockSize_ = 20;
    private int piledRectSize_ = (int)((double)this.piledBlockSize_ * 2.5);
    private int piledLength_;
    private Point piledStart_;
    private int boardPiledMargin_ = 4;

    DigestIgoBoardLayout(Rectangle rectangle, PrintingIgoBoard printingIgoBoard) {
        this(rectangle, printingIgoBoard, false);
    }

    DigestIgoBoardLayout(Rectangle rectangle, PrintingIgoBoard printingIgoBoard, boolean bl) {
        int n;
        this.showPiled_ = bl;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        SgfRectangle sgfRectangle = printingIgoBoard.getViewArea();
        this.boardStart_ = sgfRectangle.getStart();
        this.isLandscape_ = sgfRectangle.height() <= sgfRectangle.width();
        int n2 = this.showPiled_ ? printingIgoBoard.piledSize() : 0;
        int n3 = 0;
        if (this.isLandscape_) {
            this.piledLength_ = (int)Math.floor(rectangle2.width / this.piledRectSize_);
            n = (int)Math.ceil((double)n2 / (double)this.piledLength_);
            n3 = n * this.piledBlockSize_ + this.boardPiledMargin_;
            rectangle2.height -= n3;
        } else {
            this.piledLength_ = (int)Math.floor(rectangle2.height / this.piledRectSize_);
            n = (int)Math.ceil((double)n2 / (double)this.piledLength_);
            n3 = n * this.piledBlockSize_ + this.boardPiledMargin_;
            rectangle2.width -= n3;
        }
        this.blockSize_ = Math.min(rectangle2.width / sgfRectangle.width(), rectangle2.height / sgfRectangle.height());
        Point point = new Point(rectangle2.width - this.blockSize_ * sgfRectangle.width(), rectangle2.height - this.blockSize_ * sgfRectangle.height());
        if (this.isLandscape_) {
            this.boardOffset_ = n3 <= point.y ? new Point(point.x / 2, (point.y + n3) / 2) : new Point(point.x / 2, point.y);
            this.piledStart_ = new Point(this.boardOffset_.x, rectangle2.height + this.boardPiledMargin_);
        } else {
            this.boardOffset_ = n3 <= point.x ? new Point((point.x + n3) / 2, point.y / 2) : new Point(point.x, point.y / 2);
            this.piledStart_ = new Point(rectangle2.width + this.boardPiledMargin_, this.boardOffset_.y);
        }
    }

    boolean isLandscapeStyle() {
        return this.isLandscape_;
    }

    Rectangle getBlockArea(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.boardOffset_.x + (n - this.boardStart_.x()) * this.blockSize_, this.boardOffset_.y + (n2 - this.boardStart_.y()) * this.blockSize_, this.blockSize_, this.blockSize_);
        return rectangle;
    }

    int getPiledBlockSize() {
        return this.piledBlockSize_;
    }

    Point getPiledStoneStart(int n) {
        int n2 = n % this.piledLength_;
        int n3 = n / this.piledLength_;
        if (this.isLandscape_) {
            return new Point(this.piledStart_.x + n2 * this.piledRectSize_, this.piledStart_.y + n3 * this.piledBlockSize_);
        }
        return new Point(this.piledStart_.x + n3 * this.piledBlockSize_, this.piledStart_.y + n2 * this.piledRectSize_);
    }

    public int getBlockSize() {
        return this.blockSize_;
    }
}

