/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.SgfId;
import org.unitarou.swt.Swts;
import org.unitarou.util.Adaptable;
import org.unitarou.util.CharsetLabeler;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.ann.Editor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CharsetEditor
extends Editor
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(CharsetEditor.class);
    private final List<Charset> charsets_;
    private String lastDatum_ = null;
    private Combo combo_ = null;
    private final ComboListener comboListener_ = new ComboListener();
    private final Adapter adapter_ = new Adapter();
    private final CharsetLabeler labeler_;

    CharsetEditor() {
        Yukinoshita.context().addListener(this.adapter_);
        this.charsets_ = new ArrayList<Charset>();
        this.labeler_ = new CharsetLabeler();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.combo_ = new Combo(composite, 4);
        this.combo_.setLayoutData(new GridData(768));
        this.combo_.setData(SgfId.CHARSET);
        this.combo_.addFocusListener(this.comboListener_);
        this.combo_.addSelectionListener(this.comboListener_);
        Swts.defeatMouseWheel(this.combo_);
        this.updateComboItems();
        return this.combo_;
    }

    private void updateComboItems() {
        if (this.combo_ == null) {
            return;
        }
        Charset charset = null;
        int n = this.combo_.getSelectionIndex();
        if (n != -1) {
            charset = this.charsets_.get(n);
        }
        this.charsets_.clear();
        this.combo_.removeAll();
        CurrentContext currentContext = Yukinoshita.context(null);
        for (Charset charset2 : currentContext.getAttribute(Context.CHARSET_OPTIONS)) {
            this.charsets_.add(charset2);
            this.combo_.add(this.labeler_.label(charset2));
        }
        int n2 = this.charsets_.indexOf(charset);
        if (charset != null && n2 == -1) {
            this.charsets_.add(charset);
            this.combo_.add(this.labeler_.label(charset));
            this.combo_.setText(this.combo_.getItem(this.combo_.getItemCount() - 1));
        } else if (n2 != -1) {
            this.combo_.setText(this.combo_.getItem(n2));
        } else {
            this.combo_.setText("");
        }
    }

    @Override
    public Control getControl() {
        return this.combo_;
    }

    @Override
    public void close() {
    }

    void setEditable(boolean bl) {
        this.combo_.setEnabled(bl);
    }

    void setDatum(String string) {
        if (string.equals(this.lastDatum_)) {
            return;
        }
        this.lastDatum_ = string;
        this.combo_.deselectAll();
        try {
            Charset charset = Charset.forName(string);
            String string2 = this.labeler_.label(charset);
            int n = this.combo_.indexOf(string2);
            if (n != -1) {
                this.combo_.setText(this.combo_.getItem(n));
            } else {
                assert (!this.charsets_.contains(charset));
                this.combo_.add(string2, 0);
                this.charsets_.add(0, charset);
                this.combo_.setText(this.combo_.getItem(0));
            }
        }
        catch (Exception exception) {
            log_s_.log(LogLevel.DEBUG, exception, "Unknown charset: {0}", string);
            this.combo_.setText(string);
        }
    }

    @Override
    String getString() {
        int n = this.combo_.indexOf(this.combo_.getText());
        if (n == -1) {
            return this.combo_.getText();
        }
        if (this.charsets_.size() <= n) {
            return "";
        }
        return this.charsets_.get(n).name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements ContextListener {
        private Adapter() {
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (!set.contains(Context.CHARSET_OPTIONS.id())) {
                return;
            }
            CharsetEditor.this.updateComboItems();
        }
    }

    private class ComboListener
    extends FocusAdapter
    implements SelectionListener {
        private ComboListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!this.isSameCharset()) {
                CharsetEditor.this.fireModifyText(CharsetEditor.this.combo_);
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (!this.isSameCharset()) {
                CharsetEditor.this.fireModifyText(CharsetEditor.this.combo_);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            if (!this.isSameCharset()) {
                CharsetEditor.this.fireModifyText(CharsetEditor.this.combo_);
            }
        }

        private boolean isSameCharset() {
            String string = CharsetEditor.this.getString();
            try {
                Charset charset = Charset.forName(string);
                Charset charset2 = Charset.forName(CharsetEditor.this.lastDatum_);
                if (charset != null || charset2 != null) {
                    return Objects.equalsIncludeNull(charset, charset2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            return Objects.equalsIncludeNull(string, CharsetEditor.this.lastDatum_);
        }
    }
}

