/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.unitarou.io.Ios;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;

public class OpenTemplateAction
extends AbstractAction {
    private static final Log log_s_ = LogFactory.getLog(OpenTemplateAction.class);
    private static final Message NT_CANT_OPEN_TEMPLATE = new Message(OpenTemplateAction.class, "ntCantOpenTemplate");
    private static final Message MSG_CANT_OPEN_TEMPLATE = new Message(OpenTemplateAction.class, "msgCantOpenTemplate");
    private static final Message NT_TEMPLATE_IS_EMPTY = new Message(OpenTemplateAction.class, "ntTemplateIsEmpty");
    private static final Message MSG_TEMPLATE_IS_EMPTY = new Message(OpenTemplateAction.class, "msgTemplateIsEmpty");

    public OpenTemplateAction(WindowController windowController) {
        super(windowController);
    }

    public void run() {
        boolean bl;
        Collection collection = FileManager.instance().openNoDialog(FileManager.FILE_TEMPLATE, false);
        if (collection.size() != 0) {
            bl = false;
        } else if (!FileManager.FILE_TEMPLATE.exists()) {
            collection = new Collection();
            collection.setFile(FileManager.FILE_TEMPLATE);
            collection.addLast(RootGameTreeFactory.createProblem(SgfSize.DEFAULT, SgfColor.BLACK));
            try {
                FileManager.instance().save(collection);
            }
            catch (YukinoshitaException yukinoshitaException) {
                log_s_.log(LogLevel.WARN, yukinoshitaException, "Failure to save.");
            }
            bl = false;
        } else {
            if (!Ios.isNormalFile(FileManager.FILE_TEMPLATE)) {
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.ERROR, NT_CANT_OPEN_TEMPLATE.get(), MSG_CANT_OPEN_TEMPLATE.get((Object)FileManager.FILE_TEMPLATE.getAbsolutePath()));
                return;
            }
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, NT_TEMPLATE_IS_EMPTY.get(), MSG_TEMPLATE_IS_EMPTY.get((Object)FileManager.FILE_TEMPLATE.getAbsolutePath()));
            collection.addLast(RootGameTreeFactory.createProblem(SgfSize.DEFAULT, SgfColor.BLACK));
            bl = true;
        }
        this.controller_.registerCollection(collection, null, bl, 0);
        EventBroker eventBroker = this.controller_.getActiveCollectionController().getEventBroker();
        eventBroker.executeCommand(new ChangeEditModeCommand(true));
        eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
    }
}

