/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.GwGbLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.WindowControllerListener;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwGbValueAction
extends AbstractAction
implements Adaptable {
    private static final Set<Property> exclusives_s_;
    private static final Message LB_ADD;
    private static final Message LB_REMOVE;
    private final Adapter adapter_;
    private final Property property_;
    private GwGbLabelProvider provider_;
    private final Property[] exclusives_;
    private GameType gameType_;
    private boolean isAddMode_;

    public GwGbValueAction(WindowController windowController, Property property) {
        super(windowController);
        ArgumentChecker.throwIfNull((Object)property);
        this.adapter_ = new Adapter();
        this.property_ = new Property(property);
        this.provider_ = new GwGbLabelProvider();
        this.controller_.addListener(this.adapter_);
        this.gameType_ = GameType.GAME;
        SgfId sgfId = this.property_.sgfId();
        if (!sgfId.equals(SgfId.GOOD_FOR_WHITE) && !sgfId.equals(SgfId.GOOD_FOR_BLACK)) {
            throw new IllegalArgumentException();
        }
        HashSet<Property> hashSet = new HashSet<Property>(exclusives_s_);
        this.isAddMode_ = true;
        this.updateText();
        if (hashSet.remove(this.property_)) {
            hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
            hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.NORMAL));
        } else {
            hashSet.clear();
        }
        this.exclusives_ = hashSet.toArray(new Property[hashSet.size()]);
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        UpdateProperty updateProperty = this.isAddMode_ ? new UpdateProperty(this.exclusives_, this.property_, null) : new UpdateProperty(new Property[]{this.property_}, null, null);
        this.controller_.getActiveCollectionController().getEventBroker().executeCommand(updateProperty);
    }

    private void updateText() {
        this.setText(this.isAddMode_ ? LB_ADD.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)) : LB_REMOVE.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)));
    }

    static {
        ArrayList<Property> arrayList = new ArrayList<Property>(8);
        arrayList.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL));
        exclusives_s_ = Collections.unmodifiableSet(new HashSet(arrayList));
        LB_ADD = new Message(GwGbValueAction.class, "lbAdd");
        LB_REMOVE = new Message(GwGbValueAction.class, "lbRemove");
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(GwGbValueAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            if (collectionController != null) {
                collectionController.getEventBroker().addView(GwGbValueAction.this);
                GwGbValueAction.this.gameType_ = collectionController.getCollectionProxy().getActive().getGameType();
            }
            this.update();
        }

        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            GwGbValueAction.this.gameType_ = rgtProxy.getGameType();
            this.currentChanged(rgtProxy.getCurrentNodeView());
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (GwGbValueAction.this.property_ == null) {
                GwGbValueAction.this.isAddMode_ = false;
                GwGbValueAction.this.setEnabled(false);
                for (Property property : GwGbValueAction.this.exclusives_) {
                    if (null == nodeView.getProperty(property.sgfId())) continue;
                    GwGbValueAction.this.setEnabled(true);
                }
                return;
            }
            Property property = nodeView.getProperty(GwGbValueAction.this.property_.sgfId());
            GwGbValueAction.this.isAddMode_ = property == null || !property.getString().equals(GwGbValueAction.this.property_.getString());
            GwGbValueAction.this.provider_.setPlayerColor(GameType.PROBLEM.equals(GwGbValueAction.this.gameType_) ? nodeView.getRootView().firstMove() : null);
            this.update();
        }

        private void update() {
            EnumSet<GameType> enumSet = GwGbValueAction.this.property_ == null ? EnumSet.of(GwGbValueAction.this.gameType_) : GwGbValueAction.this.property_.sgfId().gameTypes();
            CollectionController collectionController = this.refGfc_.get();
            GwGbValueAction.this.setEnabled(collectionController != null && collectionController.isEditMode() && enumSet.contains(GwGbValueAction.this.gameType_));
            if (!enumSet.contains(GwGbValueAction.this.gameType_)) {
                GwGbValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
                return;
            }
            GwGbValueAction.this.updateText();
        }

        public void setEditMode(boolean bl) {
            CollectionController collectionController = this.refGfc_.get();
            this.currentChanged(collectionController.getCollectionProxy().getActive().getNodeList().getCurrentNodeView());
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

