/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.WindowControllerListener;
import org.unitarou.yukinoshita.view.cmd.FilterRgtCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearRgtFilter
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(ClearRgtFilter.class);
    private final Adapter adapter_;
    private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

    public ClearRgtFilter(WindowController windowController) {
        super(windowController);
        this.adapter_ = new Adapter();
        windowController.addListener(new WindowControllerListener(){

            public void changeActive(CollectionController collectionController) {
                ClearRgtFilter.this.changeController(collectionController);
            }
        });
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void changeController(CollectionController collectionController) {
        CollectionController collectionController2 = this.refGfc_.get();
        if (collectionController2 != null) {
            collectionController2.getEventBroker().removeView(this);
        }
        if (collectionController == null) {
            this.setEnabled(false);
        } else {
            collectionController.getEventBroker().addView(this);
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            this.setEnabled(this.isRgtFiltered(collectionController));
        }
    }

    private boolean isRgtFiltered(CollectionController collectionController) {
        return collectionController != null && collectionController.getCollectionProxy().size() != collectionController.getIndexFilter().size();
    }

    @Override
    public void run() {
        CollectionController collectionController = this.controller_.getActiveCollectionController();
        if (collectionController == null) {
            log_s_.log(LogLevel.WARN, "[BUG] Can't find Controller.");
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collectionController.getCollectionProxy().size());
        for (int i = 0; i < collectionController.getCollectionProxy().size(); ++i) {
            arrayList.add(i);
        }
        collectionController.getEventBroker().executeCommand(new FilterRgtCommand(arrayList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements CollectionMonitor {
        private Adapter() {
        }

        @Override
        public void update(CollectionProxy collectionProxy) {
            CollectionController collectionController = (CollectionController)ClearRgtFilter.this.refGfc_.get();
            ClearRgtFilter.this.setEnabled(ClearRgtFilter.this.isRgtFiltered(collectionController));
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            CollectionController collectionController = (CollectionController)ClearRgtFilter.this.refGfc_.get();
            ClearRgtFilter.this.setEnabled(ClearRgtFilter.this.isRgtFiltered(collectionController));
        }
    }
}

