/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.AbstractViewCommand;

public class ChangeGameCommand
extends AbstractViewCommand {
    private final int gameIndex_;

    public ChangeGameCommand(int n) {
        ArgumentChecker.throwIfNegative(n);
        this.gameIndex_ = n;
    }

    public void execute() {
        this.throwIfNotSetup();
        boolean bl = this.isEditMode();
        RgtProxy rgtProxy = this.getCollectionProxy().getActive();
        GameType gameType = rgtProxy.getGameType();
        if (!bl && gameType.equals(GameType.PROBLEM)) {
            rgtProxy.endSolvingProblem();
        }
        this.getCollectionProxy().setActive(this.gameIndex_);
        RgtProxy rgtProxy2 = this.getCollectionProxy().getActive();
        GameType gameType2 = rgtProxy2.getGameType();
        if (!gameType.equals(gameType2)) {
            this.getEventBroker().connect(gameType2, bl);
        }
        if (!bl && gameType2.equals(GameType.PROBLEM)) {
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
        }
        this.fireGameViewerUpdate();
        this.fireNodeViewerUpdate();
    }
}

