/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sql.Checker;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.Table;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable
implements Table {
    private static final Log log_s_ = LogFactory.getLog(AbstractTable.class);
    public static final Message NT_CRATE_TABLE = new Message(AbstractTable.class, "ntCreateTable");
    public static final Message NT_NO_CHECK_BY_VERSION = new Message(AbstractTable.class, "ntNoCheckByVersion");

    @Override
    public void create(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        queryRunner.update(connection, "DROP TABLE " + this.getTable() + " IF EXISTS");
        String string = HsqldbQueryBuilder.instance().buildTable(this.getTable(), this.getColumns(), this.getPrimaryKeys(), this.getInTableConstraints());
        log_s_.log(LogLevel.TRACE, "CREATE:{0}", string);
        queryRunner.update(connection, string);
    }

    @Override
    public void addConstraint(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        for (String string : this.getInterTableConstraintQueries()) {
            queryRunner.update(connection, string);
        }
    }

    @Override
    public final CheckerResult selfCheck(Connection connection) {
        return this.selfCheck(connection, DatabaseVersion.CURRENT);
    }

    public CheckerResult selfCheck(Connection connection, DatabaseVersion databaseVersion) {
        if (!this.exists(databaseVersion)) {
            return new CheckerResult(NT_NO_CHECK_BY_VERSION.get(new Object[]{this.getTable(), databaseVersion}), CheckerResultType.MATCH);
        }
        CheckerResult checkerResult = null;
        try {
            checkerResult = this.checkTable(connection);
        }
        catch (SQLException sQLException) {
            return new CheckerResult(Checker.NT_DB_ERROR.get((Object)sQLException.getLocalizedMessage()), CheckerResultType.UNMATCH);
        }
        ArrayList<CheckerResult> arrayList = new ArrayList<CheckerResult>();
        try {
            this.checkColumns(connection, databaseVersion, arrayList);
            arrayList.add(this.checkForignKeys(connection, databaseVersion));
        }
        catch (SQLException sQLException) {
            arrayList.add(new CheckerResult(Checker.NT_DB_ERROR.get((Object)sQLException.getLocalizedMessage()), CheckerResultType.UNMATCH));
        }
        for (CheckerResult checkerResult2 : arrayList) {
            checkerResult.addChild(checkerResult2);
        }
        return checkerResult;
    }

    private CheckerResult checkTable(Connection connection) throws SQLException {
        CheckerResult checkerResult = Checker.instance().hasTable(connection, this);
        if (CheckerResultType.NOT_FOUND == checkerResult.getType()) {
            this.create(connection);
            this.addConstraint(connection);
            checkerResult = new CheckerResult(NT_CRATE_TABLE.get((Object)this.getTable()), CheckerResultType.MATCH);
        }
        return checkerResult;
    }

    private void checkColumns(Connection connection, DatabaseVersion databaseVersion, List<CheckerResult> list) throws SQLException {
        list.addAll(Checker.instance().hasColumn(connection, this.getTable(), this.getColumns(databaseVersion)));
        list.add(Checker.instance().hasPrimeryKey(connection, this.getTable(), this.getPrimaryKeys(databaseVersion)));
    }

    private CheckerResult checkForignKeys(Connection connection, DatabaseVersion databaseVersion) throws SQLException {
        CheckerResult checkerResult = Checker.instance().hasForeignKey(connection, this.getTable(), this.getForeignKeys(databaseVersion));
        if (checkerResult.getType() == CheckerResultType.NOT_FOUND) {
            log_s_.log(LogLevel.INFO, "FK\u304c\u5916\u308c\u3066\u3044\u305f\u306e\u3067\u518d\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30c6\u30fc\u30d6\u30eb\u540d\uff1a{0}", this.getTable());
            QueryRunner queryRunner = new QueryRunner();
            for (String string : this.getInterTableConstraintQueries()) {
                try {
                    queryRunner.update(connection, string);
                }
                catch (SQLException sQLException) {
                    log_s_.log(LogLevel.INFO, sQLException, "FK\u518d\u8a2d\u5b9a\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u304c\u7121\u8996\u3057\u307e\u3059\u3002\u30c6\u30fc\u30d6\u30eb\u540d\uff1a{0}", this.getTable());
                }
            }
            checkerResult = Checker.instance().hasForeignKey(connection, this.getTable(), this.getForeignKeys(databaseVersion));
        }
        return checkerResult;
    }

    public abstract boolean exists(DatabaseVersion var1);

    @Override
    public final PrimaryKey[] getPrimaryKeys() {
        return this.getPrimaryKeys(DatabaseVersion.CURRENT);
    }

    protected abstract PrimaryKey[] getPrimaryKeys(DatabaseVersion var1);

    @Override
    public final ForeignKey[] getForeignKeys() {
        return this.getForeignKeys(DatabaseVersion.CURRENT);
    }

    protected abstract ForeignKey[] getForeignKeys(DatabaseVersion var1);

    public final HsqldbColumn[] getColumns() {
        return this.getColumns(DatabaseVersion.CURRENT);
    }

    protected abstract HsqldbColumn[] getColumns(DatabaseVersion var1);

    protected abstract String getInTableConstraints();

    protected abstract String[] getInterTableConstraintQueries();
}

