/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.ForStackTraceException;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.StoneGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoBoard
implements IgoBoardView {
    private static final Log log_s_ = LogFactory.getLog(IgoBoard.class);
    private SgfSize size_;
    private final Set<StoneGroup> blackGroups_;
    private final Set<StoneGroup> whiteGroups_;
    private final Map<SgfPoint, Stone> allStones_;
    private final List<Stone> captured_;
    private final Set<SgfPoint> invalidStones_;
    private ForStackTraceException stackTraceOfConstructor_;

    public IgoBoard(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.size_ = sgfSize;
        this.blackGroups_ = new HashSet<StoneGroup>(2);
        this.whiteGroups_ = new HashSet<StoneGroup>(2);
        this.allStones_ = new HashMap<SgfPoint, Stone>();
        this.captured_ = new ArrayList<Stone>(0);
        this.invalidStones_ = new HashSet<SgfPoint>();
        if (log_s_.isEnabled(LogLevel.DEBUG)) {
            this.stackTraceOfConstructor_ = new ForStackTraceException();
            this.stackTraceOfConstructor_.fillInStackTrace();
        }
    }

    public void setCaptured(List<Stone> list) {
        ArgumentChecker.throwIfNull(list);
        this.captured_.clear();
        this.captured_.addAll(list);
    }

    public void removeCaptured(List<Stone> list) {
        ArgumentChecker.throwIfNull(list);
        if (!log_s_.isEnabled(LogLevel.DEBUG)) {
            this.captured_.removeAll(list);
            return;
        }
        for (Stone stone : list) {
            if (!this.captured_.remove(stone)) assert (false);
        }
    }

    public void setSize(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        if (this.size_.equals(sgfSize)) {
            return;
        }
        this.size_ = sgfSize;
        this.allStones_.clear();
        this.blackGroups_.clear();
        this.whiteGroups_.clear();
        this.invalidStones_.clear();
    }

    public Stone[] moveStone(Stone stone) {
        ArgumentChecker.throwIfNull((Object)stone);
        SgfPoint sgfPoint = stone.getPoint();
        SgfColor sgfColor = stone.getColor();
        this.setStone(stone);
        if (sgfPoint.condition() == SgfPointType.PASS) {
            return Stone.EMPTY_ARRAY;
        }
        return this.removeDeadStone(sgfColor.opposite());
    }

    public void setStone(Stone stone) {
        Object object;
        ArgumentChecker.throwIfNull((Object)stone);
        SgfPoint sgfPoint = stone.getPoint();
        SgfColor sgfColor = stone.getColor();
        ArgumentChecker.throwIfNull((Object)sgfPoint, (Object)sgfColor);
        if (sgfPoint.condition() == SgfPointType.OUT) {
            throw new IllegalArgumentException("Bad point:" + sgfPoint);
        }
        if (sgfPoint.condition() == SgfPointType.PASS) {
            return;
        }
        Collection<SgfPoint> collection = this.findLifePoints(sgfPoint);
        Set<StoneGroup> set = this.getStoneGroups(sgfColor);
        if (!this.appendStone(set, sgfPoint, collection)) {
            object = new StoneGroup(this.size_);
            ((StoneGroup)object).add(sgfPoint, collection);
            set.add((StoneGroup)object);
        }
        if ((object = this.allStones_.put(sgfPoint, stone)) != null) {
            this.invalidStones_.add(((Stone)object).getPoint());
        }
        for (StoneGroup stoneGroup : this.getStoneGroups(sgfColor.opposite())) {
            stoneGroup.removeLifePoint(sgfPoint);
        }
    }

    private Set<StoneGroup> getStoneGroups(SgfColor sgfColor) {
        return sgfColor == SgfColor.BLACK ? this.blackGroups_ : this.whiteGroups_;
    }

    private boolean appendStone(Collection<StoneGroup> collection, SgfPoint sgfPoint, Collection<SgfPoint> collection2) {
        StoneGroup stoneGroup2;
        assert (collection != null && sgfPoint != null && collection2 != null);
        ArrayList<StoneGroup> arrayList = new ArrayList<StoneGroup>(4);
        for (StoneGroup stoneGroup2 : collection) {
            if (!stoneGroup2.isLifePoint(sgfPoint)) continue;
            arrayList.add(stoneGroup2);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        Iterator<StoneGroup> iterator = arrayList.iterator();
        stoneGroup2 = iterator.next();
        stoneGroup2.add(sgfPoint, collection2);
        while (iterator.hasNext()) {
            StoneGroup stoneGroup3 = iterator.next();
            stoneGroup2.add(stoneGroup3);
            collection.remove(stoneGroup3);
        }
        return true;
    }

    public SgfColor removeStone(SgfPoint sgfPoint) {
        StoneGroup stoneGroup;
        this.allStones_.remove(sgfPoint);
        this.invalidStones_.remove(sgfPoint);
        Iterator<StoneGroup> iterator = this.blackGroups_.iterator();
        while (iterator.hasNext()) {
            stoneGroup = iterator.next();
            if (!stoneGroup.contains(sgfPoint)) continue;
            StoneGroup[] stoneGroupArray = stoneGroup.remove(sgfPoint);
            if (stoneGroup.count() == 0) {
                iterator.remove();
            }
            for (int i = 1; i < stoneGroupArray.length; ++i) {
                this.blackGroups_.add(stoneGroupArray[i]);
            }
            Set<StoneGroup> set = this.whiteGroups_;
            for (StoneGroup stoneGroup2 : set) {
                stoneGroup2.addLifePoint(sgfPoint);
            }
            return SgfColor.BLACK;
        }
        iterator = this.whiteGroups_.iterator();
        while (iterator.hasNext()) {
            stoneGroup = iterator.next();
            if (!stoneGroup.contains(sgfPoint)) continue;
            StoneGroup[] stoneGroupArray = stoneGroup.remove(sgfPoint);
            if (stoneGroup.count() == 0) {
                iterator.remove();
            }
            for (int i = 1; i < stoneGroupArray.length; ++i) {
                this.whiteGroups_.add(stoneGroupArray[i]);
            }
            Set<StoneGroup> set = this.blackGroups_;
            for (StoneGroup stoneGroup3 : set) {
                stoneGroup3.addLifePoint(sgfPoint);
            }
            return SgfColor.WHITE;
        }
        return null;
    }

    private Stone[] removeDeadStone(SgfColor sgfColor) {
        Set<StoneGroup> set = this.getStoneGroups(sgfColor);
        Set<StoneGroup> set2 = this.getStoneGroups(sgfColor.opposite());
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        Stone[] stoneArray = set.iterator();
        while (stoneArray.hasNext()) {
            StoneGroup stoneGroup = (StoneGroup)stoneArray.next();
            if (stoneGroup.countLifePoint() != 0) continue;
            stoneArray.remove();
            hashSet.addAll(stoneGroup.stones());
        }
        for (StoneGroup stoneGroup : set2) {
            for (SgfPoint sgfPoint : hashSet) {
                stoneGroup.addLifePoint(sgfPoint);
            }
        }
        stoneArray = new Stone[hashSet.size()];
        int n = 0;
        for (SgfPoint sgfPoint : hashSet) {
            Stone stone = this.allStones_.get(sgfPoint);
            if (stone != null) {
                this.captured_.add(stone);
                stoneArray[n] = this.allStones_.get(sgfPoint);
                this.allStones_.remove(sgfPoint);
                this.invalidStones_.remove(sgfPoint);
            } else assert (false) : "Not found stone " + sgfPoint + " in " + BasicFormatter.format(this.allStones_.keySet());
            ++n;
        }
        return stoneArray;
    }

    @Override
    public boolean isForbiddenMove(SgfPoint sgfPoint, SgfColor sgfColor, SgfPoint sgfPoint2, Stone[] stoneArray) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, (Object)sgfColor, (Object)sgfPoint2, (Object)stoneArray);
        if (!this.isEmpty(sgfPoint)) {
            return true;
        }
        Set<StoneGroup> set = this.getStoneGroups(sgfColor.opposite());
        for (StoneGroup object2 : set) {
            if (object2.countLifePoint() != 1 || !object2.isLifePoint(sgfPoint)) continue;
            return this.isKoViolation(object2, sgfPoint, sgfPoint2, stoneArray);
        }
        int n = this.findLifePoints(sgfPoint).size();
        if (n != 0) {
            return false;
        }
        Set<StoneGroup> set2 = this.getStoneGroups(sgfColor);
        for (StoneGroup stoneGroup : set2) {
            if (!stoneGroup.isLifePoint(sgfPoint) || (n += stoneGroup.countLifePoint() - 1) == 0) continue;
            return false;
        }
        return n == 0;
    }

    @Override
    public SortedMap<SgfPoint, SgfColor> diff(IgoBoard igoBoard) {
        ArgumentChecker.throwIfNull((Object)igoBoard);
        if (!this.size_.equals(igoBoard.size_)) {
            throw new IllegalArgumentException("Bad size: " + this.size_ + "!=" + igoBoard.size_);
        }
        TreeMap<SgfPoint, SgfColor> treeMap = new TreeMap<SgfPoint, SgfColor>();
        this.diff(SgfColor.BLACK, igoBoard.blackGroups_, this.blackGroups_, treeMap);
        this.diff(SgfColor.WHITE, igoBoard.whiteGroups_, this.whiteGroups_, treeMap);
        return treeMap;
    }

    private void diff(SgfColor sgfColor, Collection<StoneGroup> collection, Collection<StoneGroup> collection2, SortedMap<SgfPoint, SgfColor> sortedMap) {
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>();
        for (StoneGroup iterator2 : collection) {
            treeSet.addAll(iterator2.stones());
        }
        TreeSet treeSet2 = new TreeSet();
        for (StoneGroup stoneGroup : collection2) {
            treeSet2.addAll(stoneGroup.stones());
        }
        Iterator iterator = treeSet.iterator();
        Iterator iterator2 = treeSet2.iterator();
        block2: while (iterator.hasNext() || iterator2.hasNext()) {
            if (!iterator.hasNext()) {
                while (iterator2.hasNext()) {
                    sortedMap.put((SgfPoint)iterator2.next(), sgfColor);
                }
                continue;
            }
            if (!iterator2.hasNext()) {
                while (iterator.hasNext()) {
                    this.putNull(sortedMap, (SgfPoint)iterator.next());
                }
                continue;
            }
            SgfPoint sgfPoint = (SgfPoint)iterator.next();
            SgfPoint sgfPoint2 = (SgfPoint)iterator2.next();
            while (true) {
                int n;
                if ((n = sgfPoint.compareTo(sgfPoint2)) < 0) {
                    this.putNull(sortedMap, sgfPoint);
                    if (!iterator.hasNext()) {
                        sortedMap.put(sgfPoint2, sgfColor);
                        while (iterator2.hasNext()) {
                            sortedMap.put((SgfPoint)iterator2.next(), sgfColor);
                        }
                        continue block2;
                    }
                    sgfPoint = (SgfPoint)iterator.next();
                    continue;
                }
                if (0 >= n) continue block2;
                sortedMap.put(sgfPoint2, sgfColor);
                if (!iterator2.hasNext()) {
                    this.putNull(sortedMap, sgfPoint);
                    while (iterator.hasNext()) {
                        this.putNull(sortedMap, (SgfPoint)iterator.next());
                    }
                    continue block2;
                }
                sgfPoint2 = (SgfPoint)iterator2.next();
            }
        }
    }

    private void putNull(Map<SgfPoint, SgfColor> map, SgfPoint sgfPoint) {
        if (!map.containsKey(sgfPoint)) {
            map.put(sgfPoint, null);
        }
    }

    private boolean isKoViolation(StoneGroup stoneGroup, SgfPoint sgfPoint, SgfPoint sgfPoint2, Stone[] stoneArray) {
        assert (stoneGroup != null && sgfPoint != null && sgfPoint2 != null && stoneArray != null);
        return stoneArray.length == 1 && sgfPoint.equals(stoneArray[0].getPoint()) && stoneGroup.count() == 1 && stoneGroup.stones().contains(sgfPoint2);
    }

    private Collection<SgfPoint> findLifePoints(SgfPoint sgfPoint) {
        assert (sgfPoint != null);
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>(4);
        for (SgfPoint sgfPoint2 : sgfPoint.neighbors()) {
            if (!this.isEmpty(sgfPoint2)) continue;
            arrayList.add(sgfPoint2);
        }
        return arrayList;
    }

    private boolean isEmpty(SgfPoint sgfPoint) {
        assert (sgfPoint != null);
        return !this.allStones_.containsKey(sgfPoint);
    }

    @Override
    public Set<SgfPoint> position(SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfColor);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        Set<StoneGroup> set = this.getStoneGroups(sgfColor);
        for (StoneGroup stoneGroup : set) {
            hashSet.addAll(stoneGroup.stones());
        }
        return hashSet;
    }

    @Override
    public SgfSize size() {
        return this.size_;
    }

    @Override
    public List<Stone> getCaptured(SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfColor);
        ArrayList<Stone> arrayList = new ArrayList<Stone>(this.captured_.size());
        for (Stone stone : this.captured_) {
            if (!sgfColor.opposite().equals(stone.getColor())) continue;
            arrayList.add(stone);
        }
        return arrayList;
    }

    @Override
    public List<Stone> getCaptured() {
        return Collections.unmodifiableList(this.captured_);
    }

    @Override
    public Stone getStone(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.allStones_.get(sgfPoint);
    }

    @Override
    public int lifePoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        for (StoneGroup stoneGroup : this.blackGroups_) {
            if (!stoneGroup.contains(sgfPoint)) continue;
            return stoneGroup.countLifePoint();
        }
        for (StoneGroup stoneGroup : this.whiteGroups_) {
            if (!stoneGroup.contains(sgfPoint)) continue;
            return stoneGroup.countLifePoint();
        }
        return -1;
    }

    @Override
    public Set<SgfPoint> validate() {
        return Collections.unmodifiableSet(this.invalidStones_);
    }
}

