/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeListEditor
implements NodeList {
    private static final Log log_s_ = LogFactory.getLog(NodeListEditor.class);
    private final RootGameTree root_;
    private final ArrayList<NodeEntity> entityList_;
    private final Map<NodeEntity, Integer> entityIndex_;
    private int boardIndex_;
    private int positionIndex_;
    private MarkupIgoBoard igoBoard_;

    public NodeListEditor(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.root_ = rootGameTree;
        this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
        this.entityList_ = new ArrayList(this.getDefaultSize());
        this.entityIndex_ = new HashMap<NodeEntity, Integer>(this.getDefaultSize());
        this.boardIndex_ = -1;
        this.positionIndex_ = -1;
        this.addLast(this.root_);
    }

    private int getDefaultSize() {
        return this.root_.getGameType().equals(GameType.GAME) ? 300 : 20;
    }

    public SgfSize getSize() {
        return this.root_.getSize();
    }

    public RootGameTree getRoot() {
        return this.root_;
    }

    private int indexOfImpl(NodeEntity nodeEntity) {
        Integer n = this.entityIndex_.get(nodeEntity);
        if (n == null) {
            throw new IllegalArgumentException("nodeEntity " + nodeEntity + " is not found in entityList_");
        }
        return n;
    }

    void update(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.indexOfImpl(nodeEntity);
        nodeEntity.updateVariationIndex();
        if (n == 0) {
            this.igoBoard_ = new MarkupIgoBoard(this.igoBoard_.size());
            nodeEntity.forwardUpdate(null, this.igoBoard_);
            this.boardIndex_ = -1;
        } else {
            this.updateIgoBoard(this.entityList_.get(n - 1));
        }
    }

    MarkupIgoBoard updateIgoBoard(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.indexOfImpl(nodeEntity);
        if (this.boardIndex_ < n) {
            this.forwardUpdateIgoBoard(n);
            log_s_.log(LogLevel.TRACE, "forwardUpdateIgoBoard:{0}", n);
        } else if (n < this.boardIndex_) {
            if (n != 0) {
                this.backwardUpdateIgoBoard(n - 1);
                log_s_.log(LogLevel.TRACE, "backwardUpdateIgoBoard:" + Integer.valueOf(n - 1));
                this.forwardUpdateIgoBoard(n);
                log_s_.log(LogLevel.TRACE, "forwardUpdateIgoBoard:" + Integer.valueOf(n));
            } else {
                this.backwardUpdateIgoBoard(n);
                log_s_.log(LogLevel.TRACE, "backwardUpdateIgoBoard:" + Integer.valueOf(n));
            }
        }
        return this.igoBoard_;
    }

    private void forwardUpdateIgoBoard(int n) {
        for (int i = this.boardIndex_ + 1; i <= n; ++i) {
            NodeEntity nodeEntity = i == 0 ? null : this.entityList_.get(i - 1);
            this.entityList_.get(i).forwardUpdate(nodeEntity, this.igoBoard_);
        }
        this.boardIndex_ = n;
    }

    private void backwardUpdateIgoBoard(int n) {
        if (n == 0) {
            this.clearIgoBoard();
            return;
        }
        for (int i = this.boardIndex_; i >= n + 1; --i) {
            this.entityList_.get(i).backwardUpdate(this.igoBoard_);
        }
        this.boardIndex_ = n;
    }

    private void clearIgoBoard() {
        this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
        this.boardIndex_ = -1;
    }

    private void rollback(int n) {
        if (!this.entityList_.isEmpty()) {
            this.updateIgoBoard(this.entityList_.get(n));
        }
    }

    public void addLast(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        this.addLastImpl(gameTree);
    }

    private void addLastImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            NodeEntity nodeEntity = this.createNodeEntity(node, gameTree);
            this.addEntityImpl(nodeEntity);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.addLastImpl(gameTree.getChild(0));
        }
        SgfArgumentChecker.throwIfInvalid(this.root_);
    }

    private NodeEntity createNodeEntity(Node node, GameTree gameTree) {
        return new NodeEntity(node, gameTree, this, this.entityList_.isEmpty() ? null : this.getLast());
    }

    public void addLast(NodeEntity[] nodeEntityArray) {
        ArgumentChecker.throwIfNull((Object)nodeEntityArray);
        for (NodeEntity nodeEntity : nodeEntityArray) {
            this.addLastImpl(nodeEntity);
        }
    }

    public void addLast(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        this.addLastImpl(nodeEntity);
    }

    private void addLastImpl(NodeEntity nodeEntity) {
        nodeEntity.updateVariationIndex();
        nodeEntity.setPrevious(this.entityList_.isEmpty() ? null : this.getLast());
        this.addEntityImpl(nodeEntity);
    }

    private void addEntityImpl(NodeEntity nodeEntity) {
        this.entityIndex_.put(nodeEntity, this.entityList_.size());
        this.entityList_.add(nodeEntity);
    }

    public NodeEntity addLast(Node node, GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree);
        NodeEntity nodeEntity = this.createNodeEntity(node, gameTree);
        this.addEntityImpl(nodeEntity);
        return nodeEntity;
    }

    public NodeEntity insert(Node node, GameTree gameTree, NodeEntity nodeEntity) {
        SgfArgumentChecker.throwIfNotAChild(node, gameTree);
        int n = this.indexOfImpl(nodeEntity);
        NodeEntity nodeEntity2 = null;
        if (n == 0) {
            log_s_.log(LogLevel.WARN, "Can't rollback because of zero index");
        } else {
            this.rollback(n - 1);
            nodeEntity2 = this.get(n - 1);
        }
        NodeEntity nodeEntity3 = new NodeEntity(node, gameTree, this, nodeEntity2);
        nodeEntity3.setPrevious(this.entityList_.size() <= n ? null : this.entityList_.get(n - 1));
        this.entityList_.add(n, nodeEntity3);
        this.entityIndex_.put(nodeEntity3, n);
        return nodeEntity3;
    }

    public boolean remove(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int n = this.indexOf(nodeEntity);
        if (0 < n) {
            this.removeImpl(n);
            this.rollback(n);
            return true;
        }
        return false;
    }

    public NodeEntity removeLast() {
        if (this.entityList_.isEmpty()) {
            throw new NoSuchElementException("entityList_ is empty");
        }
        if (this.entityList_.size() == 1) {
            this.clearIgoBoard();
        } else {
            this.rollback(this.entityList_.size() - 2);
        }
        NodeEntity nodeEntity = this.removeImpl(this.entityList_.size() - 1);
        return nodeEntity;
    }

    private NodeEntity removeImpl(int n) {
        NodeEntity nodeEntity = this.entityList_.remove(n);
        this.entityIndex_.remove(nodeEntity);
        nodeEntity.setPrevious(null);
        return nodeEntity;
    }

    public NodeEntity getPosition() {
        return this.get(this.positionIndex_);
    }

    public void setPositionIndex(int n) {
        ArgumentChecker.throwsIfOutOfBounds(n, this.entityList_);
        this.positionIndex_ = n;
    }

    @Override
    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public NodeEntity get(int n) {
        return this.entityList_.get(n);
    }

    int indexOf(NodeEntity nodeEntity) {
        Integer n = this.entityIndex_.get(nodeEntity);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public NodeEntity getLast() {
        if (this.entityList_.isEmpty()) {
            throw new IllegalStateException("Current list is empty.");
        }
        return this.entityList_.get(this.entityList_.size() - 1);
    }

    @Override
    public int size() {
        return this.entityList_.size();
    }

    public boolean contains(NodeEntity nodeEntity) {
        return this.entityIndex_.containsKey(nodeEntity);
    }

    @Override
    public NodeView getLastNodeView() {
        return this.getLast().getNodeView();
    }

    @Override
    public NodeView getNodeView(int n) {
        return this.get(n).getNodeView();
    }

    @Override
    public NodeView getCurrentNodeView() {
        return this.getPosition().getNodeView();
    }

    public boolean refresh(Set<SgfId> set) {
        ArgumentChecker.throwIfNull(set);
        if (set.contains(SgfId.SIZE)) {
            this.root_.clearPropertyCache();
            this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
            this.entityList_.clear();
            this.entityIndex_.clear();
            this.boardIndex_ = -1;
            this.positionIndex_ = -1;
            this.addLast(this.root_);
            return true;
        }
        if (set.contains(SgfId.STYLE)) {
            this.root_.clearPropertyCache();
            if (this.root_.getStyle().isChildrenStyle()) {
                for (int i = 1; i < this.entityList_.size(); ++i) {
                    NodeEntity nodeEntity = this.entityList_.get(i - 1);
                    NodeEntity nodeEntity2 = this.entityList_.get(i);
                    nodeEntity.setSelectedVariationIndex(nodeEntity2.getUnmodifiedSelectVariationIndex());
                }
                this.entityList_.get(this.entityList_.size() - 1).setSelectedVariationIndex(-1);
            } else {
                for (int i = this.entityList_.size() - 1; 0 < i; --i) {
                    NodeEntity nodeEntity = this.entityList_.get(i - 1);
                    NodeEntity nodeEntity3 = this.entityList_.get(i);
                    nodeEntity3.setSelectedVariationIndex(nodeEntity.getUnmodifiedSelectVariationIndex());
                }
                this.entityList_.get(0).setSelectedVariationIndex(-1);
            }
            return true;
        }
        return false;
    }
}

