/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.unitarou.io.Ios;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.io.dl.DefaultHttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardProvider;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

public class Yukinoshita {
    private static final String PROPERTIES_FILE_NAME = "." + File.separator + "yukinoshita.properties";
    private static final Log log_s_ = LogFactory.getLog(Yukinoshita.class);
    private static final Message NT_FILE_READ_ERROR = new Message(Yukinoshita.class, "ntFileReadError");
    private static final Message MSG_PROPERTIES_FILE_NOT_FOUND = new Message(Yukinoshita.class, "msgPropertiesFileNotFound");
    private static final String target = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz [];:\n\r\\";
    private static final byte[] asciiBytes_s_;
    private static final Message MSG_PROPERTIES_READ_ERROR;
    private static final Message NT_BAD_PARAMETER_IN_PROPERTIES;
    private static final Message MSG_BAD_APPLICATION_CLASS_NAME;
    private static final Message MSG_BAD_PROVIDER_CLASS_NAME;
    private static final Message MSG_BAD_ARGUMENT_FILE_NOT_FOUND;
    private static final String PROP_KEY_APPLICATION = "application";
    private static final String PROP_DEF_APPLICATION = "org.unitarou.yukinoshita.view.jface.JFaceApplication";
    private static final String PROP_KEY_PREFIX_PROVIDER = "provider.";
    public static final String USER_NAME;
    public static final String NAME = "Yukinoshita";
    public static final String VERSION = "2.2.5";
    public static final String LAST_UPDATE = "2008/9";
    public static final String COPYRIGHT = "Copyright (c) 2001--2008 unitarou.";
    public static final String ALL_RIGHTS_RESERVED = "All Rights Reserved.";
    public static final String MAIL = "boss@unitarou.org";
    private static Yukinoshita yukinoshita_s_;
    private final Properties properties_ = this.readProperties();
    private final Application application_ = this.loadApplication();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            yukinoshita_s_ = new Yukinoshita();
            File[] fileArray = Yukinoshita.parseFile(stringArray);
            yukinoshita_s_.start(fileArray);
            Messages.inspectUnusedMessages();
        }
        catch (Throwable throwable) {
            log_s_.log(LogLevel.FATAL, throwable, "Uncaught exception error.");
        }
        finally {
            if (yukinoshita_s_ != null) {
                yukinoshita_s_.close();
            }
        }
    }

    private static File[] parseFile(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            File file = new File(string);
            if (Ios.isNormalFile(file)) {
                arrayList.add(file);
                continue;
            }
            log_s_.log(LogLevel.INFO, MSG_BAD_ARGUMENT_FILE_NOT_FOUND.get((Object)string));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static Yukinoshita instance() {
        return yukinoshita_s_;
    }

    public static Application application() {
        return yukinoshita_s_ == null ? null : Yukinoshita.yukinoshita_s_.application_;
    }

    public static Context context() {
        if (yukinoshita_s_ != null && Yukinoshita.yukinoshita_s_.application_ != null) {
            return Yukinoshita.yukinoshita_s_.application_.getContext();
        }
        return null;
    }

    public static CurrentContext context(Object object) {
        return Yukinoshita.yukinoshita_s_.application_.getContext().getCurrent(object);
    }

    public static void callDebugInitializer() {
        if (yukinoshita_s_ != null) {
            return;
        }
        yukinoshita_s_ = new Yukinoshita();
        yukinoshita_s_.setupProvider();
        Yukinoshita.yukinoshita_s_.application_.getContext().load();
        DatabaseManager.instance().startup();
    }

    private Yukinoshita() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties readProperties() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(PROPERTIES_FILE_NAME);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log_s_.log(LogLevel.WARN, fileNotFoundException, "Properties file is not found.");
            JOptionPane.showMessageDialog(null, MSG_PROPERTIES_FILE_NOT_FOUND.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            IOUtils.closeQuietly(fileInputStream);
        }
        catch (IOException iOException) {
            log_s_.log(LogLevel.WARN, iOException, "Failure to read properties file.");
            JOptionPane.showMessageDialog(null, MSG_PROPERTIES_READ_ERROR.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fileInputStream);
        }
        IOUtils.closeQuietly(fileInputStream);
        return properties;
    }

    private Application loadApplication() {
        String string = this.properties_.getProperty(PROP_KEY_APPLICATION, PROP_DEF_APPLICATION);
        try {
            Class<?> clazz = Class.forName(string);
            return (Application)clazz.newInstance();
        }
        catch (Exception exception) {
            log_s_.log(LogLevel.WARN, exception, "Failure to create an application instance.");
            JOptionPane.showMessageDialog(null, MSG_BAD_APPLICATION_CLASS_NAME.get(PROP_KEY_APPLICATION, string, PROP_DEF_APPLICATION, PROPERTIES_FILE_NAME), NT_BAD_PARAMETER_IN_PROPERTIES.get(), 2);
            try {
                return (Application)Class.forName(PROP_DEF_APPLICATION).newInstance();
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2);
            }
        }
    }

    private void start(File[] fileArray) {
        this.setupProvider();
        this.application_.getContext().load();
        DatabaseManager.instance().startup();
        this.application_.start(fileArray);
    }

    private void setupProvider() {
        Context context = this.application_.getContext();
        context.registerInterface(CoordinatesLabelProvider.class);
        context.registerInterface(VariationLabelProvider.class);
        context.registerInterface(BlockLabelProvider.class);
        context.registerInterface(RootGameTreeLabelProvider.class);
        context.registerInterface(HttpDownloader.class);
        context.registerInterface(AsciiBoardProvider.class);
        context.registerProvider(CoordinatesLabelProvider.CONTEXT.defaultValue().getClass());
        context.registerProvider(VariationLabelProvider.CONTEXT.defaultValue().getClass());
        context.registerProvider(BlockLabelProvider.CONTEXT.defaultValue().getClass());
        context.registerProvider(RootGameTreeLabelProvider.CONTEXT.defaultValue().getClass());
        context.registerProvider(DefaultHttpDownloader.class);
        context.registerProvider(NoVariationProvider.class);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties_.entrySet()) {
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            treeMap.put(string, string2);
        }
        for (Map.Entry<Object, Object> entry : treeMap.entrySet()) {
            this.registerProvider((String)entry.getKey(), (String)entry.getValue(), context);
        }
    }

    private void registerProvider(String string, String string2, Context context) {
        try {
            if (string.startsWith(PROP_KEY_PREFIX_PROVIDER)) {
                context.registerProvider(Class.forName(string2));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.log(LogLevel.WARN, classNotFoundException, "Failure to set provider class.");
            this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_BAD_PARAMETER_IN_PROPERTIES.get(), MSG_BAD_PROVIDER_CLASS_NAME.get(string, string2, PROPERTIES_FILE_NAME));
        }
    }

    private void close() {
        Ios.closeQuietly(DatabaseManager.instance());
        Ios.closeQuietly(this.application_);
    }

    public boolean isInvalidCharset(Charset charset) {
        return charset == null || !charset.canEncode() || this.isNoAsciiCodec(charset);
    }

    private boolean isNoAsciiCodec(Charset charset) {
        ByteBuffer byteBuffer = charset.encode(target);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        byteBuffer.rewind();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        return !Arrays.equals(asciiBytes_s_, byArray) || !target.equals(charBuffer.toString());
    }

    static {
        Charset charset = Charset.forName("ISO-8859-1");
        ByteBuffer byteBuffer = charset.encode(target);
        asciiBytes_s_ = new byte[byteBuffer.limit()];
        byteBuffer.get(asciiBytes_s_);
        MSG_PROPERTIES_READ_ERROR = new Message(Yukinoshita.class, "msgPropertiesReadError");
        NT_BAD_PARAMETER_IN_PROPERTIES = new Message(Yukinoshita.class, "ntBadParameterInProperties");
        MSG_BAD_APPLICATION_CLASS_NAME = new Message(Yukinoshita.class, "msgBadApplicationClassName");
        MSG_BAD_PROVIDER_CLASS_NAME = new Message(Yukinoshita.class, "msgBadProviderClassName");
        MSG_BAD_ARGUMENT_FILE_NOT_FOUND = new Message(Yukinoshita.class, "msgBadArgumentFileNotFound");
        USER_NAME = System.getProperty("user.name", "yukinoshita");
    }
}

