/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.swt.ComboStyle;
import org.unitarou.swt.UComboProvider;
import org.unitarou.swt.WidgetContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCombo<T>
implements WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(UCombo.class);
    private final UComboProvider<T> provider_;
    private final boolean permitsNoChoise_;
    private final boolean readOnly_;
    private final int comboStyle_;
    private final List<T> items_;
    private Combo combo_;

    public UCombo(UComboProvider<T> uComboProvider) {
        this(uComboProvider, EnumSet.of(ComboStyle.READ_ONLY, ComboStyle.PERMIT_NO_CHOICE));
    }

    public UCombo(UComboProvider<T> uComboProvider, EnumSet<ComboStyle> enumSet) {
        ArgumentChecker.throwIfNull(uComboProvider, enumSet);
        this.provider_ = uComboProvider;
        this.permitsNoChoise_ = enumSet.contains((Object)ComboStyle.PERMIT_NO_CHOICE);
        this.readOnly_ = enumSet.contains((Object)ComboStyle.READ_ONLY);
        this.comboStyle_ = 4 | (enumSet.contains((Object)ComboStyle.READ_ONLY) ? 8 : 0);
        this.items_ = new ArrayList<T>();
    }

    public void addAll(Collection<T> collection) {
        ArgumentChecker.throwIfNull(collection);
        this.items_.addAll(collection);
        if (this.combo_ == null) {
            return;
        }
        for (T t : collection) {
            this.combo_.add(this.provider_.getString(t));
        }
    }

    public void clear() {
        this.items_.clear();
        if (this.combo_ == null) {
            return;
        }
        this.combo_.removeAll();
        if (this.permitsNoChoise_) {
            this.combo_.add("");
        }
    }

    @Override
    public Combo createContents(Composite composite) {
        if (this.combo_ != null) {
            return this.combo_;
        }
        this.combo_ = new Combo(composite, this.comboStyle_);
        if (this.permitsNoChoise_) {
            this.combo_.add("");
        }
        for (T t : this.items_) {
            this.combo_.add(this.provider_.getString(t));
        }
        return this.combo_;
    }

    @Override
    public Combo getControl() {
        return this.combo_;
    }

    @Override
    public void close() {
    }

    public void select(T t) {
        if (t == null) {
            if (!this.permitsNoChoise_) {
                throw new IllegalStateException("Need PERMIT_NO_CHOICE");
            }
            this.combo_.setText("");
            return;
        }
        String string = this.provider_.getString(t);
        int n = this.combo_.indexOf(string);
        if (n < 0 && this.readOnly_) {
            log_s_.log(LogLevel.WARN, "[IGNORE]Unregistered item: {0}", t);
        } else {
            this.combo_.setText(string);
        }
    }

    public void setText(String string) {
        for (T t : this.items_) {
            if (!this.provider_.getId(t).equals(string)) continue;
            this.combo_.setText(this.provider_.getString(t));
            return;
        }
        this.combo_.setText(string);
    }

    public String getText() {
        return this.combo_.getText();
    }

    public String getId() {
        int n = this.combo_.indexOf(this.combo_.getText());
        if (this.permitsNoChoise_) {
            if (n <= 0) {
                return this.combo_.getText();
            }
            return this.provider_.getId(this.items_.get(n - 1));
        }
        if (n < 0) {
            return this.combo_.getText();
        }
        return this.provider_.getId(this.items_.get(n));
    }

    public T getSelected() {
        int n = this.combo_.indexOf(this.combo_.getText());
        if (this.permitsNoChoise_) {
            if (n <= 0) {
                return null;
            }
            return this.items_.get(n - 1);
        }
        if (n < 0) {
            return null;
        }
        return this.items_.get(n);
    }
}

